/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpPipeliningClient;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalIODispatch;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class CloseableHttpAsyncClientBase
extends CloseableHttpPipeliningClient {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final Thread reactorThread;
    private final AtomicReference<Status> status;

    public CloseableHttpAsyncClientBase(final NHttpClientConnectionManager nHttpClientConnectionManager, ThreadFactory threadFactory, final NHttpClientEventHandler nHttpClientEventHandler) {
        this.connmgr = nHttpClientConnectionManager;
        this.reactorThread = threadFactory != null && nHttpClientEventHandler != null ? threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    InternalIODispatch internalIODispatch = new InternalIODispatch(nHttpClientEventHandler);
                    nHttpClientConnectionManager.execute(internalIODispatch);
                }
                catch (Exception exception) {
                    CloseableHttpAsyncClientBase.this.log.error((Object)"I/O reactor terminated abnormally", (Throwable)exception);
                }
                finally {
                    CloseableHttpAsyncClientBase.this.status.set(Status.STOPPED);
                }
            }
        }) : null;
        this.status = new AtomicReference<Status>(Status.INACTIVE);
    }

    @Override
    public void start() {
        if (this.status.compareAndSet(Status.INACTIVE, Status.ACTIVE) && this.reactorThread != null) {
            this.reactorThread.start();
        }
    }

    protected void ensureRunning() {
        Status status = this.status.get();
        Asserts.check((status == Status.ACTIVE ? 1 : 0) != 0, (String)"Request cannot be executed; I/O reactor status: %s", (Object)status);
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(Status.ACTIVE, Status.STOPPED) && this.reactorThread != null) {
            try {
                this.connmgr.shutdown();
            }
            catch (IOException iOException) {
                this.log.error((Object)"I/O error shutting down connection manager", (Throwable)iOException);
            }
            try {
                this.reactorThread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.status.get() == Status.ACTIVE;
    }
}

