/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.icbc.api.internal.apache.http.nio.client.HttpPipeliningClient;
import com.icbc.api.internal.apache.http.nio.client.methods.HttpAsyncMethods;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpPipeliningClient
extends CloseableHttpAsyncClient
implements HttpPipeliningClient {
    @Override
    public <T> Future<List<T>> execute(HttpHost httpHost, List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, FutureCallback<List<T>> futureCallback) {
        return this.execute(httpHost, list, list2, HttpClientContext.create(), futureCallback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost httpHost, List<HttpRequest> list, FutureCallback<List<HttpResponse>> futureCallback) {
        return this.execute(httpHost, list, (HttpContext)HttpClientContext.create(), futureCallback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost httpHost, List<HttpRequest> list, HttpContext httpContext, FutureCallback<List<HttpResponse>> futureCallback) {
        Args.notEmpty(list, (String)"HTTP request list");
        ArrayList<HttpAsyncRequestProducer> arrayList = new ArrayList<HttpAsyncRequestProducer>(list.size());
        ArrayList<HttpAsyncResponseConsumer<HttpResponse>> arrayList2 = new ArrayList<HttpAsyncResponseConsumer<HttpResponse>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            HttpRequest httpRequest = list.get(i);
            arrayList.add(HttpAsyncMethods.create(httpHost, httpRequest));
            arrayList2.add(HttpAsyncMethods.createConsumer());
        }
        return this.execute(httpHost, arrayList, arrayList2, httpContext, futureCallback);
    }
}

