/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.methods.HttpExecutionAware;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalClientExec;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalState;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import java.io.IOException;
import org.apache.commons.logging.Log;

class DefaultClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> resultFuture;
    private final InternalClientExec exec;
    private final InternalState state;

    public DefaultClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpClientContext httpClientContext, BasicFuture<T> basicFuture, NHttpClientConnectionManager nHttpClientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, InternalClientExec internalClientExec) {
        super(log, httpClientContext, basicFuture, nHttpClientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy);
        this.requestProducer = httpAsyncRequestProducer;
        this.responseConsumer = httpAsyncResponseConsumer;
        this.resultFuture = basicFuture;
        this.exec = internalClientExec;
        this.state = new InternalState(this.getId(), httpAsyncRequestProducer, httpAsyncResponseConsumer, httpClientContext);
    }

    @Override
    void releaseResources() {
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing request producer", (Throwable)iOException);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing response consumer", (Throwable)iOException);
        }
    }

    @Override
    void executionFailed(Exception exception) {
        this.requestProducer.failed(exception);
        this.responseConsumer.failed(exception);
    }

    @Override
    boolean executionCancelled() {
        boolean bl = this.responseConsumer.cancel();
        T t = this.responseConsumer.getResult();
        Exception exception = this.responseConsumer.getException();
        if (exception != null) {
            this.resultFuture.failed(exception);
        } else if (t != null) {
            this.resultFuture.completed(t);
        } else {
            this.resultFuture.cancel();
        }
        return bl;
    }

    public void start() throws HttpException, IOException {
        HttpHost httpHost = this.requestProducer.getTarget();
        HttpRequest httpRequest = this.requestProducer.generateRequest();
        if (httpRequest instanceof HttpExecutionAware) {
            ((HttpExecutionAware)((Object)httpRequest)).setCancellable(this);
        }
        this.exec.prepare(httpHost, httpRequest, this.state, this);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.exec.generateRequest(this.state, this);
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        this.exec.produceContent(this.state, contentEncoder, iOControl);
    }

    @Override
    public void requestCompleted() {
        this.exec.requestCompleted(this.state, this);
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        this.exec.responseReceived(httpResponse, this.state, this);
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        this.exec.consumeContent(this.state, contentDecoder, iOControl);
        if (!contentDecoder.isCompleted() && this.responseConsumer.isDone()) {
            this.markConnectionNonReusable();
            try {
                this.markCompleted();
                this.releaseConnection();
                this.resultFuture.cancel();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void responseCompleted() throws IOException, HttpException {
        this.exec.responseCompleted(this.state, this);
        if (this.state.getFinalResponse() != null || this.resultFuture.isDone()) {
            try {
                this.markCompleted();
                this.releaseConnection();
                T t = this.responseConsumer.getResult();
                Exception exception = this.responseConsumer.getException();
                if (exception == null) {
                    this.resultFuture.completed(t);
                }
                this.resultFuture.failed(exception);
            }
            finally {
                this.close();
            }
        } else {
            NHttpClientConnection nHttpClientConnection = this.getConnection();
            if (nHttpClientConnection != null && !nHttpClientConnection.isOpen()) {
                this.releaseConnection();
                nHttpClientConnection = null;
            }
            if (nHttpClientConnection != null) {
                nHttpClientConnection.requestOutput();
            } else {
                this.requestConnection();
            }
        }
    }

    @Override
    public void inputTerminated() {
        if (!this.isCompleted()) {
            this.requestConnection();
        } else {
            this.close();
        }
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

