/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalRequestExecutor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractIODispatch;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class InternalIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final Log log = LogFactory.getLog(InternalIODispatch.class);
    private final NHttpClientEventHandler handler;

    public InternalIODispatch(NHttpClientEventHandler nHttpClientEventHandler) {
        this.handler = this.log.isDebugEnabled() ? new InternalRequestExecutor(this.log, nHttpClientEventHandler) : nHttpClientEventHandler;
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession iOSession) {
        throw new IllegalStateException("Connection must be created by connection manager");
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        Object object = defaultNHttpClientConnection.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(defaultNHttpClientConnection, object);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpClientConnection, exception);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        this.handler.closed(defaultNHttpClientConnection);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection defaultNHttpClientConnection, IOException iOException) {
        this.handler.exception(defaultNHttpClientConnection, iOException);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        defaultNHttpClientConnection.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        defaultNHttpClientConnection.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection defaultNHttpClientConnection) {
        try {
            this.handler.timeout(defaultNHttpClientConnection);
        }
        catch (Exception exception) {
            this.handler.exception(defaultNHttpClientConnection, exception);
        }
    }
}

