/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import java.io.IOException;
import org.apache.commons.logging.Log;

class InternalRequestExecutor
implements NHttpClientEventHandler {
    private final Log log;
    private final NHttpClientEventHandler handler;

    public InternalRequestExecutor(Log log, NHttpClientEventHandler nHttpClientEventHandler) {
        this.log = log;
        this.handler = nHttpClientEventHandler;
    }

    @Override
    public void connected(NHttpClientConnection nHttpClientConnection, Object object) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + ": Connected"));
        }
        this.handler.connected(nHttpClientConnection, object);
    }

    @Override
    public void closed(NHttpClientConnection nHttpClientConnection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + ": Disconnected"));
        }
        this.handler.closed(nHttpClientConnection);
    }

    @Override
    public void requestReady(NHttpClientConnection nHttpClientConnection) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Request ready"));
        }
        this.handler.requestReady(nHttpClientConnection);
    }

    @Override
    public void inputReady(NHttpClientConnection nHttpClientConnection, ContentDecoder contentDecoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Input ready"));
        }
        this.handler.inputReady(nHttpClientConnection, contentDecoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " " + contentDecoder));
        }
    }

    @Override
    public void outputReady(NHttpClientConnection nHttpClientConnection, ContentEncoder contentEncoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Output ready"));
        }
        this.handler.outputReady(nHttpClientConnection, contentEncoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " " + contentEncoder));
        }
    }

    @Override
    public void responseReceived(NHttpClientConnection nHttpClientConnection) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Response received"));
        }
        this.handler.responseReceived(nHttpClientConnection);
    }

    @Override
    public void timeout(NHttpClientConnection nHttpClientConnection) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Timeout"));
        }
        this.handler.timeout(nHttpClientConnection);
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, Exception exception) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " Exception"), (Throwable)exception);
        }
        this.handler.exception(nHttpClientConnection, exception);
    }

    @Override
    public void endOfInput(NHttpClientConnection nHttpClientConnection) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(nHttpClientConnection + " End of input"));
        }
        this.handler.endOfInput(nHttpClientConnection);
    }
}

