/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.auth.AuthProtocolState;
import com.icbc.api.internal.apache.http.auth.AuthScheme;
import com.icbc.api.internal.apache.http.auth.AuthScope;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.UsernamePasswordCredentials;
import com.icbc.api.internal.apache.http.client.AuthenticationStrategy;
import com.icbc.api.internal.apache.http.client.CredentialsProvider;
import com.icbc.api.internal.apache.http.client.NonRepeatableRequestException;
import com.icbc.api.internal.apache.http.client.RedirectException;
import com.icbc.api.internal.apache.http.client.RedirectStrategy;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.methods.Configurable;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.client.protocol.RequestClientConnControl;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.conn.routing.BasicRouteDirector;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.HttpRouteDirector;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.impl.auth.HttpAuthenticator;
import com.icbc.api.internal.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalClientExec;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalState;
import com.icbc.api.internal.apache.http.message.AbstractHttpMessage;
import com.icbc.api.internal.apache.http.message.BasicHttpRequest;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.ImmutableHttpProcessor;
import com.icbc.api.internal.apache.http.protocol.RequestTargetHost;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MainClientExec
implements InternalClientExec {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpProcessor httpProcessor;
    private final HttpProcessor proxyHttpProcessor;
    private final HttpRoutePlanner routePlanner;
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final UserTokenHandler userTokenHandler;
    private final RedirectStrategy redirectStrategy;
    private final HttpRouteDirector routeDirector;
    private final HttpAuthenticator authenticator;

    public MainClientExec(HttpProcessor httpProcessor, HttpRoutePlanner httpRoutePlanner, RedirectStrategy redirectStrategy, AuthenticationStrategy authenticationStrategy, AuthenticationStrategy authenticationStrategy2, UserTokenHandler userTokenHandler) {
        this.httpProcessor = httpProcessor;
        this.proxyHttpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl());
        this.routePlanner = httpRoutePlanner;
        this.redirectStrategy = redirectStrategy;
        this.targetAuthStrategy = authenticationStrategy;
        this.proxyAuthStrategy = authenticationStrategy2;
        this.userTokenHandler = userTokenHandler;
        this.routeDirector = new BasicRouteDirector();
        this.authenticator = new HttpAuthenticator(this.log);
    }

    @Override
    public void prepare(HttpHost httpHost, HttpRequest httpRequest, InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws HttpException, IOException {
        Object object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + internalState.getId() + "] start execution"));
        }
        HttpClientContext httpClientContext = internalState.getLocalContext();
        if (httpRequest instanceof Configurable && (object = ((Configurable)((Object)httpRequest)).getConfig()) != null) {
            httpClientContext.setRequestConfig((RequestConfig)object);
        }
        if ((object = httpClientContext.getRedirectLocations()) != null) {
            object.clear();
        }
        HttpRequestWrapper httpRequestWrapper = HttpRequestWrapper.wrap(httpRequest);
        HttpRoute httpRoute = this.routePlanner.determineRoute(httpHost, httpRequestWrapper, httpClientContext);
        abstractClientExchangeHandler.setRoute(httpRoute);
        internalState.setMainRequest(httpRequestWrapper);
        abstractClientExchangeHandler.setCurrentRequest(httpRequestWrapper);
        this.prepareRequest(internalState, abstractClientExchangeHandler);
    }

    @Override
    public HttpRequest generateRequest(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws IOException, HttpException {
        Object object;
        Object object2;
        HttpRoute httpRoute = abstractClientExchangeHandler.getRoute();
        abstractClientExchangeHandler.verifytRoute();
        if (!abstractClientExchangeHandler.isRouteEstablished()) {
            int n;
            block9: do {
                object2 = abstractClientExchangeHandler.getActualRoute();
                n = this.routeDirector.nextStep(httpRoute, (RouteInfo)object2);
                switch (n) {
                    case 1: {
                        abstractClientExchangeHandler.onRouteToTarget();
                        break;
                    }
                    case 2: {
                        abstractClientExchangeHandler.onRouteToProxy();
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("[exchange: " + internalState.getId() + "] Tunnel required"));
                        }
                        object = this.createConnectRequest(httpRoute, internalState);
                        abstractClientExchangeHandler.setCurrentRequest(HttpRequestWrapper.wrap((HttpRequest)object));
                        break block9;
                    }
                    case 4: {
                        throw new HttpException("Proxy chains are not supported");
                    }
                    case 5: {
                        abstractClientExchangeHandler.onRouteUpgrade();
                        break;
                    }
                    case -1: {
                        throw new HttpException("Unable to establish route: planned = " + httpRoute + "; current = " + object2);
                    }
                    case 0: {
                        abstractClientExchangeHandler.onRouteComplete();
                        this.log.debug((Object)"Connection route established");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown step indicator " + n + " from RouteDirector.");
                    }
                }
            } while (n > 0);
        }
        HttpClientContext httpClientContext = internalState.getLocalContext();
        object2 = abstractClientExchangeHandler.getCurrentRequest();
        if (object2 == null) {
            object2 = internalState.getMainRequest();
            abstractClientExchangeHandler.setCurrentRequest((HttpRequestWrapper)object2);
        }
        if (abstractClientExchangeHandler.isRouteEstablished()) {
            internalState.incrementExecCount();
            if (internalState.getExecCount() > 1) {
                object = internalState.getRequestProducer();
                if (!object.isRepeatable() && internalState.isRequestContentProduced()) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                }
                object.resetRequest();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + internalState.getId() + "] Attempt " + internalState.getExecCount() + " to execute request"));
            }
            if (!((AbstractHttpMessage)object2).containsHeader("Authorization")) {
                object = httpClientContext.getTargetAuthState();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Target auth state: " + ((AuthState)object).getState()));
                }
                this.authenticator.generateAuthResponse((HttpRequest)object2, (AuthState)object, httpClientContext);
            }
            if (!((AbstractHttpMessage)object2).containsHeader("Proxy-Authorization") && !httpRoute.isTunnelled()) {
                object = httpClientContext.getProxyAuthState();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Proxy auth state: " + ((AuthState)object).getState()));
                }
                this.authenticator.generateAuthResponse((HttpRequest)object2, (AuthState)object, httpClientContext);
            }
        } else if (!((AbstractHttpMessage)object2).containsHeader("Proxy-Authorization")) {
            object = httpClientContext.getProxyAuthState();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Proxy auth state: " + ((AuthState)object).getState()));
            }
            this.authenticator.generateAuthResponse((HttpRequest)object2, (AuthState)object, httpClientContext);
        }
        object = abstractClientExchangeHandler.getConnection();
        httpClientContext.setAttribute("http.connection", object);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (requestConfig.getSocketTimeout() > 0) {
            object.setSocketTimeout(requestConfig.getSocketTimeout());
        }
        return object2;
    }

    @Override
    public void produceContent(InternalState internalState, ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + internalState.getId() + "] produce content"));
        }
        HttpAsyncRequestProducer httpAsyncRequestProducer = internalState.getRequestProducer();
        internalState.setRequestContentProduced();
        httpAsyncRequestProducer.produceContent(contentEncoder, iOControl);
        if (contentEncoder.isCompleted()) {
            httpAsyncRequestProducer.resetRequest();
        }
    }

    @Override
    public void requestCompleted(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + internalState.getId() + "] Request completed"));
        }
        HttpClientContext httpClientContext = internalState.getLocalContext();
        HttpAsyncRequestProducer httpAsyncRequestProducer = internalState.getRequestProducer();
        httpAsyncRequestProducer.requestCompleted(httpClientContext);
    }

    @Override
    public void responseReceived(HttpResponse httpResponse, InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + internalState.getId() + "] Response received " + httpResponse.getStatusLine()));
        }
        HttpClientContext httpClientContext = internalState.getLocalContext();
        httpClientContext.setAttribute("http.response", httpResponse);
        this.httpProcessor.process(httpResponse, (HttpContext)httpClientContext);
        abstractClientExchangeHandler.setCurrentResponse(httpResponse);
        if (!abstractClientExchangeHandler.isRouteEstablished()) {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            if (n == 200) {
                abstractClientExchangeHandler.onRouteTunnelToTarget();
                abstractClientExchangeHandler.setCurrentRequest(null);
            } else if (!this.handleConnectResponse(internalState, abstractClientExchangeHandler)) {
                internalState.setFinalResponse(httpResponse);
            }
        } else if (!this.handleResponse(internalState, abstractClientExchangeHandler)) {
            internalState.setFinalResponse(httpResponse);
        }
        if (internalState.getFinalResponse() != null) {
            HttpAsyncResponseConsumer<?> httpAsyncResponseConsumer = internalState.getResponseConsumer();
            httpAsyncResponseConsumer.responseReceived(httpResponse);
        }
    }

    @Override
    public void consumeContent(InternalState internalState, ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + internalState.getId() + "] Consume content"));
        }
        if (internalState.getFinalResponse() != null) {
            HttpAsyncResponseConsumer<?> httpAsyncResponseConsumer = internalState.getResponseConsumer();
            httpAsyncResponseConsumer.consumeContent(contentDecoder, iOControl);
        } else {
            ByteBuffer byteBuffer = internalState.getTmpbuf();
            byteBuffer.clear();
            contentDecoder.read(byteBuffer);
        }
    }

    @Override
    public void responseCompleted(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws IOException, HttpException {
        Object object;
        Object object2;
        int n;
        HttpClientContext httpClientContext = internalState.getLocalContext();
        HttpResponse httpResponse = abstractClientExchangeHandler.getCurrentResponse();
        if (!abstractClientExchangeHandler.isRouteEstablished() && (n = httpResponse.getStatusLine().getStatusCode()) == 200) {
            abstractClientExchangeHandler.setCurrentResponse(null);
            return;
        }
        n = abstractClientExchangeHandler.manageConnectionPersistence();
        if (n == 0) {
            abstractClientExchangeHandler.releaseConnection();
            object2 = httpClientContext.getProxyAuthState();
            if (((AuthState)object2).getState() == AuthProtocolState.SUCCESS && ((AuthState)object2).getAuthScheme() != null && ((AuthState)object2).getAuthScheme().isConnectionBased()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + internalState.getId() + "] Resetting proxy auth state"));
                }
                ((AuthState)object2).reset();
            }
            if (((AuthState)(object = httpClientContext.getTargetAuthState())).getState() == AuthProtocolState.SUCCESS && ((AuthState)object).getAuthScheme() != null && ((AuthState)object).getAuthScheme().isConnectionBased()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + internalState.getId() + "] Resetting target auth state"));
                }
                ((AuthState)object).reset();
            }
        }
        if ((object2 = httpClientContext.getUserToken()) == null) {
            object2 = this.userTokenHandler.getUserToken(httpClientContext);
            httpClientContext.setAttribute("http.user-token", object2);
        }
        if (internalState.getFinalResponse() != null) {
            object = internalState.getResponseConsumer();
            object.responseCompleted(httpClientContext);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + internalState.getId() + "] Response processed"));
            }
            abstractClientExchangeHandler.releaseConnection();
        } else if (internalState.getRedirect() != null) {
            Object object3;
            Object object4;
            object = internalState.getRedirect();
            URI uRI = object.getURI();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + internalState.getId() + "] Redirecting to '" + uRI + "'"));
            }
            internalState.setRedirect(null);
            HttpHost httpHost = URIUtils.extractHost(uRI);
            if (httpHost == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uRI);
            }
            HttpRoute httpRoute = abstractClientExchangeHandler.getRoute();
            if (!httpRoute.getTargetHost().equals(httpHost)) {
                object4 = httpClientContext.getTargetAuthState();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + internalState.getId() + "] Resetting target auth state"));
                }
                ((AuthState)object4).reset();
                object3 = httpClientContext.getProxyAuthState();
                AuthScheme authScheme = ((AuthState)object3).getAuthScheme();
                if (authScheme != null && authScheme.isConnectionBased()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("[exchange: " + internalState.getId() + "] Resetting proxy auth state"));
                    }
                    ((AuthState)object3).reset();
                }
            }
            if (!object.headerIterator().hasNext()) {
                object4 = internalState.getMainRequest().getOriginal();
                object.setHeaders(object4.getAllHeaders());
            }
            if (!httpRoute.equals(object3 = this.routePlanner.determineRoute(httpHost, (HttpRequest)(object4 = HttpRequestWrapper.wrap((HttpRequest)object)), httpClientContext))) {
                abstractClientExchangeHandler.releaseConnection();
            }
            abstractClientExchangeHandler.setRoute((HttpRoute)object3);
            abstractClientExchangeHandler.setCurrentRequest((HttpRequestWrapper)object4);
            internalState.setMainRequest((HttpRequestWrapper)object4);
            this.prepareRequest(internalState, abstractClientExchangeHandler);
        }
        abstractClientExchangeHandler.setCurrentResponse(null);
    }

    private void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute) throws ProtocolException {
        try {
            URI uRI = httpRequestWrapper.getURI();
            if (uRI != null) {
                if (httpRoute.getProxyHost() != null && !httpRoute.isTunnelled()) {
                    if (!uRI.isAbsolute()) {
                        HttpHost httpHost = httpRoute.getTargetHost();
                        uRI = URIUtils.rewriteURI(uRI, httpHost, true);
                    } else {
                        uRI = URIUtils.rewriteURI(uRI);
                    }
                } else {
                    uRI = uRI.isAbsolute() ? URIUtils.rewriteURI(uRI, null, true) : URIUtils.rewriteURI(uRI);
                }
                httpRequestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + httpRequestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    private void prepareRequest(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws IOException, HttpException {
        String string;
        Object object;
        URI uRI;
        HttpRoute httpRoute;
        HttpRequestWrapper httpRequestWrapper;
        HttpClientContext httpClientContext;
        block7: {
            httpClientContext = internalState.getLocalContext();
            httpRequestWrapper = abstractClientExchangeHandler.getCurrentRequest();
            httpRoute = abstractClientExchangeHandler.getRoute();
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            uRI = null;
            if (httpRequest instanceof HttpUriRequest) {
                uRI = ((HttpUriRequest)httpRequest).getURI();
            } else {
                object = httpRequest.getRequestLine().getUri();
                try {
                    uRI = URI.create((String)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)("Unable to parse '" + (String)object + "' as a valid URI; request URI and Host header may be inconsistent"), (Throwable)illegalArgumentException);
                }
            }
        }
        httpRequestWrapper.setURI(uRI);
        this.rewriteRequestURI(httpRequestWrapper, httpRoute);
        object = null;
        if (uRI != null && uRI.isAbsolute() && uRI.getHost() != null) {
            object = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        }
        if (object == null) {
            object = httpRoute.getTargetHost();
        }
        if (uRI != null && (string = uRI.getUserInfo()) != null) {
            CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope((HttpHost)object), new UsernamePasswordCredentials(string));
        }
        httpClientContext.setAttribute("http.request", httpRequestWrapper);
        httpClientContext.setAttribute("http.target_host", object);
        httpClientContext.setAttribute("http.route", httpRoute);
        this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
    }

    private HttpRequest createConnectRequest(HttpRoute httpRoute, InternalState internalState) throws IOException, HttpException {
        HttpHost httpHost = httpRoute.getTargetHost();
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 6);
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(Integer.toString(n));
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", stringBuilder.toString(), HttpVersion.HTTP_1_1);
        HttpClientContext httpClientContext = internalState.getLocalContext();
        this.proxyHttpProcessor.process(basicHttpRequest, (HttpContext)httpClientContext);
        return basicHttpRequest;
    }

    private boolean handleConnectResponse(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws HttpException {
        AuthState authState;
        HttpResponse httpResponse;
        HttpRoute httpRoute;
        HttpHost httpHost;
        CredentialsProvider credentialsProvider;
        HttpClientContext httpClientContext = internalState.getLocalContext();
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (requestConfig.isAuthenticationEnabled() && (credentialsProvider = httpClientContext.getCredentialsProvider()) != null && this.authenticator.isAuthenticationRequested(httpHost = (httpRoute = abstractClientExchangeHandler.getRoute()).getProxyHost(), httpResponse = abstractClientExchangeHandler.getCurrentResponse(), this.proxyAuthStrategy, authState = httpClientContext.getProxyAuthState(), httpClientContext)) {
            return this.authenticator.handleAuthChallenge(httpHost, httpResponse, this.proxyAuthStrategy, authState, httpClientContext);
        }
        return false;
    }

    private boolean handleResponse(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws HttpException {
        HttpResponse httpResponse;
        HttpRequestWrapper httpRequestWrapper;
        HttpClientContext httpClientContext = internalState.getLocalContext();
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (requestConfig.isAuthenticationEnabled() && this.needAuthentication(internalState, abstractClientExchangeHandler)) {
            HttpRequestWrapper httpRequestWrapper2 = abstractClientExchangeHandler.getCurrentRequest();
            HttpRequest httpRequest = httpRequestWrapper2.getOriginal();
            if (!httpRequest.containsHeader("Authorization")) {
                httpRequestWrapper2.removeHeaders("Authorization");
            }
            if (!httpRequest.containsHeader("Proxy-Authorization")) {
                httpRequestWrapper2.removeHeaders("Proxy-Authorization");
            }
            return true;
        }
        if (requestConfig.isRedirectsEnabled() && this.redirectStrategy.isRedirected(httpRequestWrapper = abstractClientExchangeHandler.getCurrentRequest(), httpResponse = abstractClientExchangeHandler.getCurrentResponse(), httpClientContext)) {
            int n;
            int n2 = n = requestConfig.getMaxRedirects() >= 0 ? requestConfig.getMaxRedirects() : 100;
            if (internalState.getRedirectCount() >= n) {
                throw new RedirectException("Maximum redirects (" + n + ") exceeded");
            }
            internalState.incrementRedirectCount();
            HttpUriRequest httpUriRequest = this.redirectStrategy.getRedirect(httpRequestWrapper, httpResponse, httpClientContext);
            internalState.setRedirect(httpUriRequest);
            return true;
        }
        return false;
    }

    private boolean needAuthentication(InternalState internalState, AbstractClientExchangeHandler<?> abstractClientExchangeHandler) throws HttpException {
        HttpClientContext httpClientContext = internalState.getLocalContext();
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider != null) {
            HttpRoute httpRoute = abstractClientExchangeHandler.getRoute();
            HttpResponse httpResponse = abstractClientExchangeHandler.getCurrentResponse();
            HttpHost httpHost = httpClientContext.getTargetHost();
            if (httpHost == null) {
                httpHost = httpRoute.getTargetHost();
            }
            if (httpHost.getPort() < 0) {
                httpHost = new HttpHost(httpHost.getHostName(), httpRoute.getTargetHost().getPort(), httpHost.getSchemeName());
            }
            AuthState authState = httpClientContext.getTargetAuthState();
            AuthState authState2 = httpClientContext.getProxyAuthState();
            boolean bl = this.authenticator.isAuthenticationRequested(httpHost, httpResponse, this.targetAuthStrategy, authState, httpClientContext);
            HttpHost httpHost2 = httpRoute.getProxyHost();
            if (httpHost2 == null) {
                httpHost2 = httpRoute.getTargetHost();
            }
            boolean bl2 = this.authenticator.isAuthenticationRequested(httpHost2, httpResponse, this.proxyAuthStrategy, authState2, httpClientContext);
            if (bl) {
                return this.authenticator.handleAuthChallenge(httpHost, httpResponse, this.targetAuthStrategy, authState, httpClientContext);
            }
            if (bl2) {
                return this.authenticator.handleAuthChallenge(httpHost2, httpResponse, this.proxyAuthStrategy, authState2, httpClientContext);
            }
        }
        return false;
    }
}

