/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.methods.Configurable;
import com.icbc.api.internal.apache.http.client.methods.HttpExecutionAware;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.nio.client.AbstractClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import java.io.IOException;
import org.apache.commons.logging.Log;

class MinimalClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpClientContext localContext;
    private final BasicFuture<T> resultFuture;
    private final HttpProcessor httpProcessor;

    public MinimalClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpClientContext httpClientContext, BasicFuture<T> basicFuture, NHttpClientConnectionManager nHttpClientConnectionManager, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        super(log, httpClientContext, basicFuture, nHttpClientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy);
        this.requestProducer = httpAsyncRequestProducer;
        this.responseConsumer = httpAsyncResponseConsumer;
        this.localContext = httpClientContext;
        this.resultFuture = basicFuture;
        this.httpProcessor = httpProcessor;
    }

    @Override
    void releaseResources() {
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing request producer", (Throwable)iOException);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            this.log.debug((Object)"I/O error closing response consumer", (Throwable)iOException);
        }
    }

    @Override
    void executionFailed(Exception exception) {
        this.requestProducer.failed(exception);
        this.responseConsumer.failed(exception);
    }

    @Override
    boolean executionCancelled() {
        boolean bl = this.responseConsumer.cancel();
        T t = this.responseConsumer.getResult();
        Exception exception = this.responseConsumer.getException();
        if (exception != null) {
            this.resultFuture.failed(exception);
        } else if (t != null) {
            this.resultFuture.completed(t);
        } else {
            this.resultFuture.cancel();
        }
        return bl;
    }

    public void start() throws HttpException, IOException {
        Object object;
        HttpHost httpHost = this.requestProducer.getTarget();
        HttpRequest httpRequest = this.requestProducer.generateRequest();
        if (httpRequest instanceof HttpExecutionAware) {
            ((HttpExecutionAware)((Object)httpRequest)).setCancellable(this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] start execution"));
        }
        if (httpRequest instanceof Configurable && (object = ((Configurable)((Object)httpRequest)).getConfig()) != null) {
            this.localContext.setRequestConfig((RequestConfig)object);
        }
        object = HttpRequestWrapper.wrap(httpRequest);
        HttpRoute httpRoute = new HttpRoute(httpHost);
        this.setCurrentRequest((HttpRequestWrapper)object);
        this.setRoute(httpRoute);
        this.localContext.setAttribute("http.request", object);
        this.localContext.setAttribute("http.target_host", httpHost);
        this.localContext.setAttribute("http.route", httpRoute);
        this.httpProcessor.process((HttpRequest)object, (HttpContext)this.localContext);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        this.verifytRoute();
        if (!this.isRouteEstablished()) {
            this.onRouteToTarget();
            this.onRouteComplete();
        }
        NHttpClientConnection nHttpClientConnection = this.getConnection();
        this.localContext.setAttribute("http.connection", nHttpClientConnection);
        RequestConfig requestConfig = this.localContext.getRequestConfig();
        if (requestConfig.getSocketTimeout() > 0) {
            nHttpClientConnection.setSocketTimeout(requestConfig.getSocketTimeout());
        }
        return this.getCurrentRequest();
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] produce content"));
        }
        this.requestProducer.produceContent(contentEncoder, iOControl);
        if (contentEncoder.isCompleted()) {
            this.requestProducer.resetRequest();
        }
    }

    @Override
    public void requestCompleted() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Request completed"));
        }
        this.requestProducer.requestCompleted(this.localContext);
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response received " + httpResponse.getStatusLine()));
        }
        this.localContext.setAttribute("http.response", httpResponse);
        this.httpProcessor.process(httpResponse, (HttpContext)this.localContext);
        this.setCurrentResponse(httpResponse);
        this.responseConsumer.responseReceived(httpResponse);
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Consume content"));
        }
        this.responseConsumer.consumeContent(contentDecoder, iOControl);
        if (!contentDecoder.isCompleted() && this.responseConsumer.isDone()) {
            this.markConnectionNonReusable();
            try {
                this.markCompleted();
                this.releaseConnection();
                this.resultFuture.cancel();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public void responseCompleted() throws IOException, HttpException {
        this.manageConnectionPersistence();
        this.responseConsumer.responseCompleted(this.localContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.getId() + "] Response processed"));
        }
        try {
            this.markCompleted();
            this.releaseConnection();
            T t = this.responseConsumer.getResult();
            Exception exception = this.responseConsumer.getException();
            if (exception == null) {
                this.resultFuture.completed(t);
            } else {
                this.resultFuture.failed(exception);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void inputTerminated() {
        this.close();
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

