/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.client.protocol.RequestAddCookies;
import com.icbc.api.internal.apache.http.client.protocol.RequestClientConnControl;
import com.icbc.api.internal.apache.http.client.protocol.ResponseProcessCookies;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.nio.client.IOReactorUtils;
import com.icbc.api.internal.apache.http.impl.nio.client.MinimalHttpAsyncClient;
import com.icbc.api.internal.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.HttpProcessorBuilder;
import com.icbc.api.internal.apache.http.protocol.RequestContent;
import com.icbc.api.internal.apache.http.protocol.RequestTargetHost;
import com.icbc.api.internal.apache.http.protocol.RequestUserAgent;
import com.icbc.api.internal.apache.http.util.VersionInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

class MinimalHttpAsyncClientBuilder {
    private NHttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private String userAgent;
    private ThreadFactory threadFactory;
    private boolean cookieManagementDisabled;

    public static MinimalHttpAsyncClientBuilder create() {
        return new MinimalHttpAsyncClientBuilder();
    }

    protected MinimalHttpAsyncClientBuilder() {
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManager(NHttpClientConnectionManager nHttpClientConnectionManager) {
        this.connManager = nHttpClientConnectionManager;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManagerShared(boolean bl) {
        this.connManagerShared = bl;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.reuseStrategy = connectionReuseStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.keepAliveStrategy = connectionKeepAliveStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setUserAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public MinimalHttpAsyncClient build() {
        String string;
        ConnectionKeepAliveStrategy connectionKeepAliveStrategy;
        ConnectionReuseStrategy connectionReuseStrategy;
        NHttpClientConnectionManager nHttpClientConnectionManager = this.connManager;
        if (nHttpClientConnectionManager == null) {
            nHttpClientConnectionManager = new PoolingNHttpClientConnectionManager(IOReactorUtils.create(IOReactorConfig.DEFAULT, this.threadFactory));
        }
        if ((connectionReuseStrategy = this.reuseStrategy) == null) {
            connectionReuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((connectionKeepAliveStrategy = this.keepAliveStrategy) == null) {
            connectionKeepAliveStrategy = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((string = this.userAgent) == null) {
            string = VersionInfo.getUserAgent((String)"Apache-HttpAsyncClient", (String)"org.apache.http.nio.client", this.getClass());
        }
        HttpProcessorBuilder httpProcessorBuilder = HttpProcessorBuilder.create();
        httpProcessorBuilder.addAll(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(string));
        if (!this.cookieManagementDisabled) {
            httpProcessorBuilder.add(new RequestAddCookies());
            httpProcessorBuilder.add(new ResponseProcessCookies());
        }
        HttpProcessor httpProcessor = httpProcessorBuilder.build();
        ThreadFactory threadFactory = null;
        HttpAsyncRequestExecutor httpAsyncRequestExecutor = null;
        if (!this.connManagerShared) {
            threadFactory = this.threadFactory;
            if (threadFactory == null) {
                threadFactory = Executors.defaultThreadFactory();
            }
            httpAsyncRequestExecutor = new HttpAsyncRequestExecutor();
        }
        return new MinimalHttpAsyncClient(nHttpClientConnectionManager, threadFactory, httpAsyncRequestExecutor, httpProcessor, connectionReuseStrategy, connectionKeepAliveStrategy);
    }
}

