/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class AbstractContentDecoder
implements ContentDecoder {
    protected final ReadableByteChannel channel;
    protected final SessionInputBuffer buffer;
    protected final HttpTransportMetricsImpl metrics;
    protected boolean completed;

    public AbstractContentDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        Args.notNull((Object)readableByteChannel, (String)"Channel");
        Args.notNull((Object)sessionInputBuffer, (String)"Session input buffer");
        Args.notNull((Object)httpTransportMetricsImpl, (String)"Transport metrics");
        this.buffer = sessionInputBuffer;
        this.channel = readableByteChannel;
        this.metrics = httpTransportMetricsImpl;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected int readFromChannel(ByteBuffer byteBuffer) throws IOException {
        int n = this.channel.read(byteBuffer);
        if (n > 0) {
            this.metrics.incrementBytesTransferred(n);
        }
        return n;
    }

    protected int fillBufferFromChannel() throws IOException {
        int n = this.buffer.fill(this.channel);
        if (n > 0) {
            this.metrics.incrementBytesTransferred(n);
        }
        return n;
    }

    protected int readFromChannel(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        if (byteBuffer.remaining() > n) {
            int n3 = byteBuffer.limit();
            int n4 = n3 - (byteBuffer.remaining() - n);
            byteBuffer.limit(n4);
            n2 = this.channel.read(byteBuffer);
            byteBuffer.limit(n3);
        } else {
            n2 = this.channel.read(byteBuffer);
        }
        if (n2 > 0) {
            this.metrics.incrementBytesTransferred(n2);
        }
        return n2;
    }
}

