/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractContentEncoder
implements ContentEncoder {
    protected final WritableByteChannel channel;
    protected final SessionOutputBuffer buffer;
    protected final HttpTransportMetricsImpl metrics;
    protected boolean completed;

    public AbstractContentEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        Args.notNull((Object)writableByteChannel, (String)"Channel");
        Args.notNull((Object)sessionOutputBuffer, (String)"Session input buffer");
        Args.notNull((Object)httpTransportMetricsImpl, (String)"Transport metrics");
        this.buffer = sessionOutputBuffer;
        this.channel = writableByteChannel;
        this.metrics = httpTransportMetricsImpl;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void complete() throws IOException {
        this.completed = true;
    }

    protected void assertNotCompleted() {
        Asserts.check((!this.completed ? 1 : 0) != 0, (String)"Encoding process already completed");
    }

    protected int flushToChannel() throws IOException {
        if (!this.buffer.hasData()) {
            return 0;
        }
        int n = this.buffer.flush(this.channel);
        if (n > 0) {
            this.metrics.incrementBytesTransferred(n);
        }
        return n;
    }

    protected int writeToChannel(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        int n = this.channel.write(byteBuffer);
        if (n > 0) {
            this.metrics.incrementBytesTransferred(n);
        }
        return n;
    }

    protected int writeToChannel(ByteBuffer byteBuffer, int n) throws IOException {
        return this.doWriteChunk(byteBuffer, n, true);
    }

    protected int writeToBuffer(ByteBuffer byteBuffer, int n) throws IOException {
        return this.doWriteChunk(byteBuffer, n, false);
    }

    private int doWriteChunk(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2;
        if (byteBuffer.remaining() > n) {
            int n3 = byteBuffer.limit();
            int n4 = n3 - (byteBuffer.remaining() - n);
            byteBuffer.limit(n4);
            n2 = this.doWriteChunk(byteBuffer, bl);
            byteBuffer.limit(n3);
        } else {
            n2 = this.doWriteChunk(byteBuffer, bl);
        }
        return n2;
    }

    private int doWriteChunk(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (bl) {
            int n = this.channel.write(byteBuffer);
            if (n > 0) {
                this.metrics.incrementBytesTransferred(n);
            }
            return n;
        }
        int n = byteBuffer.remaining();
        this.buffer.write(byteBuffer);
        return n;
    }
}

