/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentEncoder;
import com.icbc.api.internal.apache.http.io.BufferInfo;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChunkEncoder
extends AbstractContentEncoder {
    private final int fragHint;
    private final CharArrayBuffer lineBuffer;
    private final BufferInfo bufferinfo;

    public ChunkEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl, int n) {
        super(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl);
        this.fragHint = n > 0 ? n : 0;
        this.lineBuffer = new CharArrayBuffer(16);
        this.bufferinfo = sessionOutputBuffer instanceof BufferInfo ? (BufferInfo)((Object)sessionOutputBuffer) : null;
    }

    public ChunkEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        this(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, 0);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            int n2;
            int n3 = byteBuffer.remaining();
            int n4 = this.bufferinfo != null ? this.bufferinfo.available() : 4096;
            if ((n4 -= 12) > 0) {
                if (n4 < n3) {
                    n3 = n4;
                    this.lineBuffer.clear();
                    this.lineBuffer.append(Integer.toHexString(n3));
                    this.buffer.writeLine(this.lineBuffer);
                    n2 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + n3);
                    this.buffer.write(byteBuffer);
                    byteBuffer.limit(n2);
                } else {
                    this.lineBuffer.clear();
                    this.lineBuffer.append(Integer.toHexString(n3));
                    this.buffer.writeLine(this.lineBuffer);
                    this.buffer.write(byteBuffer);
                }
                this.lineBuffer.clear();
                this.buffer.writeLine(this.lineBuffer);
                n += n3;
            }
            if (this.buffer.length() < this.fragHint && !byteBuffer.hasRemaining() || (n2 = this.flushToChannel()) != 0) continue;
            break;
        }
        return n;
    }

    @Override
    public void complete() throws IOException {
        this.assertNotCompleted();
        this.lineBuffer.clear();
        this.lineBuffer.append("0");
        this.buffer.writeLine(this.lineBuffer);
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer);
        super.complete();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[chunk-coded; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

