/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.impl.DefaultHttpRequestFactory;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import com.icbc.api.internal.apache.http.message.BasicLineParser;
import com.icbc.api.internal.apache.http.message.LineParser;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParser;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory httpRequestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = httpRequestFactory != null ? httpRequestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer sessionInputBuffer, MessageConstraints messageConstraints) {
        return new DefaultHttpRequestParser(sessionInputBuffer, this.lineParser, this.requestFactory, messageConstraints);
    }
}

