/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentEncoder;
import com.icbc.api.internal.apache.http.nio.FileContentEncoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class IdentityEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final int fragHint;

    public IdentityEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl, int n) {
        super(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl);
        this.fragHint = n > 0 ? n : 0;
    }

    public IdentityEncoder(WritableByteChannel writableByteChannel, SessionOutputBuffer sessionOutputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl) {
        this(writableByteChannel, sessionOutputBuffer, httpTransportMetricsImpl, 0);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            return 0;
        }
        this.assertNotCompleted();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            int n2;
            if ((this.buffer.hasData() || this.fragHint > 0) && byteBuffer.remaining() <= this.fragHint && (n2 = this.fragHint - this.buffer.length()) > 0) {
                int n3 = Math.min(n2, byteBuffer.remaining());
                int n4 = this.writeToBuffer(byteBuffer, n3);
                n += n4;
            }
            if (this.buffer.hasData() && (this.buffer.length() >= this.fragHint || byteBuffer.hasRemaining()) && (n2 = this.flushToChannel()) == 0) break;
            if (this.buffer.hasData() || byteBuffer.remaining() <= this.fragHint) continue;
            n2 = this.writeToChannel(byteBuffer);
            n += n2;
            if (n2 != 0) continue;
            break;
        }
        return n;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l, long l2) throws IOException {
        if (fileChannel == null) {
            return 0L;
        }
        this.assertNotCompleted();
        this.flushToChannel();
        if (this.buffer.hasData()) {
            return 0L;
        }
        long l3 = fileChannel.transferTo(l, l2, this.channel);
        if (l3 > 0L) {
            this.metrics.incrementBytesTransferred(l3);
        }
        return l3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[identity; completed: ");
        stringBuilder.append(this.isCompleted());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

