/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.codecs;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.impl.io.HttpTransportMetricsImpl;
import com.icbc.api.internal.apache.http.impl.nio.codecs.AbstractContentDecoder;
import com.icbc.api.internal.apache.http.nio.FileContentDecoder;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

public class LengthDelimitedDecoder
extends AbstractContentDecoder
implements FileContentDecoder {
    private final long contentLength;
    private long len;

    public LengthDelimitedDecoder(ReadableByteChannel readableByteChannel, SessionInputBuffer sessionInputBuffer, HttpTransportMetricsImpl httpTransportMetricsImpl, long l) {
        super(readableByteChannel, sessionInputBuffer, httpTransportMetricsImpl);
        Args.notNegative((long)l, (String)"Content length");
        this.contentLength = l;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        Args.notNull((Object)byteBuffer, (String)"Byte buffer");
        if (this.completed) {
            return -1;
        }
        int n2 = (int)Math.min(this.contentLength - this.len, Integer.MAX_VALUE);
        if (this.buffer.hasData()) {
            int n3 = Math.min(n2, this.buffer.length());
            n = this.buffer.read(byteBuffer, n3);
        } else {
            n = this.readFromChannel(byteBuffer, n2);
        }
        if (n == -1) {
            this.completed = true;
            if (this.len < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: " + this.contentLength + "; received: " + this.len);
            }
        }
        this.len += (long)n;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        if (this.completed && n == 0) {
            return -1;
        }
        return n;
    }

    @Override
    public long transfer(FileChannel fileChannel, long l, long l2) throws IOException {
        long l3;
        if (fileChannel == null) {
            return 0L;
        }
        if (this.completed) {
            return -1L;
        }
        int n = (int)Math.min(this.contentLength - this.len, Integer.MAX_VALUE);
        if (this.buffer.hasData()) {
            int n2 = Math.min(n, this.buffer.length());
            fileChannel.position(l);
            l3 = this.buffer.read(fileChannel, n2);
        } else {
            if (this.channel.isOpen()) {
                if (l > fileChannel.size()) {
                    throw new IOException("Position past end of file [" + l + " > " + fileChannel.size() + "]");
                }
                l3 = fileChannel.transferFrom(this.channel, l, l2 < (long)n ? l2 : (long)n);
            } else {
                l3 = -1L;
            }
            if (l3 > 0L) {
                this.metrics.incrementBytesTransferred(l3);
            }
        }
        if (l3 == -1L) {
            this.completed = true;
            if (this.len < this.contentLength) {
                throw new ConnectionClosedException("Premature end of Content-Length delimited message body (expected: " + this.contentLength + "; received: " + this.len);
            }
        }
        this.len += l3;
        if (this.len >= this.contentLength) {
            this.completed = true;
        }
        return l3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[content length: ");
        stringBuilder.append(this.contentLength);
        stringBuilder.append("; pos: ");
        stringBuilder.append(this.len);
        stringBuilder.append("; completed: ");
        stringBuilder.append(this.completed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

