/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.nio.conn.CPoolEntry;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.pool.AbstractNIOConnPool;
import com.icbc.api.internal.apache.http.nio.pool.NIOConnFactory;
import com.icbc.api.internal.apache.http.nio.pool.SocketAddressResolver;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractNIOConnPool<HttpRoute, ManagedNHttpClientConnection, CPoolEntry> {
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnectingIOReactor connectingIOReactor, NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> nIOConnFactory, SocketAddressResolver<HttpRoute> socketAddressResolver, int n, int n2, long l, TimeUnit timeUnit) {
        super(connectingIOReactor, nIOConnFactory, socketAddressResolver, n, n2);
        this.timeToLive = l;
        this.tunit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute httpRoute, ManagedNHttpClientConnection managedNHttpClientConnection) {
        CPoolEntry cPoolEntry = new CPoolEntry(this.log, managedNHttpClientConnection.getId(), httpRoute, managedNHttpClientConnection, this.timeToLive, this.tunit);
        cPoolEntry.setSocketTimeout(managedNHttpClientConnection.getSocketTimeout());
        return cPoolEntry;
    }

    @Override
    protected void onLease(CPoolEntry cPoolEntry) {
        NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)cPoolEntry.getConnection();
        nHttpClientConnection.setSocketTimeout(cPoolEntry.getSocketTimeout());
    }

    @Override
    protected void onRelease(CPoolEntry cPoolEntry) {
        NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)cPoolEntry.getConnection();
        nHttpClientConnection.setSocketTimeout(0);
    }
}

