/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.nio.conn.HttpNIOConnPoolFactory;
import com.icbc.api.internal.apache.http.impl.nio.conn.HttpPoolEntry;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncScheme;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import com.icbc.api.internal.apache.http.nio.pool.AbstractNIOConnPool;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;

@Deprecated
class HttpNIOConnPool
extends AbstractNIOConnPool<HttpRoute, IOSession, HttpPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    private final Log log;
    private final AsyncSchemeRegistry schemeRegistry;
    private final long connTimeToLive;
    private final TimeUnit tunit;

    HttpNIOConnPool(Log log, ConnectingIOReactor connectingIOReactor, AsyncSchemeRegistry asyncSchemeRegistry, long l, TimeUnit timeUnit) {
        super(connectingIOReactor, new HttpNIOConnPoolFactory(), 2, 20);
        this.log = log;
        this.schemeRegistry = asyncSchemeRegistry;
        this.connTimeToLive = l;
        this.tunit = timeUnit;
    }

    @Override
    protected SocketAddress resolveLocalAddress(HttpRoute httpRoute) {
        return new InetSocketAddress(httpRoute.getLocalAddress(), 0);
    }

    @Override
    protected SocketAddress resolveRemoteAddress(HttpRoute httpRoute) {
        HttpHost httpHost = httpRoute.getProxyHost();
        if (httpHost == null) {
            httpHost = httpRoute.getTargetHost();
        }
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            AsyncScheme asyncScheme = this.schemeRegistry.getScheme(httpHost);
            n = asyncScheme.resolvePort(n);
        }
        return new InetSocketAddress(string, n);
    }

    @Override
    protected HttpPoolEntry createEntry(HttpRoute httpRoute, IOSession iOSession) {
        String string = Long.toString(COUNTER.getAndIncrement());
        return new HttpPoolEntry(this.log, string, httpRoute, iOSession, this.connTimeToLive, this.tunit);
    }
}

