/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.HttpConnectionMetrics;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.RouteTracker;
import com.icbc.api.internal.apache.http.impl.conn.ConnectionShutdownException;
import com.icbc.api.internal.apache.http.impl.nio.conn.HttpPoolEntry;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnection;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionFactory;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.ManagedClientAsyncConnection;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncScheme;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import com.icbc.api.internal.apache.http.nio.conn.scheme.LayeringStrategy;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

@Deprecated
class ManagedClientAsyncConnectionImpl
implements ManagedClientAsyncConnection {
    private final ClientAsyncConnectionManager manager;
    private final ClientAsyncConnectionFactory connFactory;
    private volatile HttpPoolEntry poolEntry;
    private volatile boolean reusable;
    private volatile long duration;

    ManagedClientAsyncConnectionImpl(ClientAsyncConnectionManager clientAsyncConnectionManager, ClientAsyncConnectionFactory clientAsyncConnectionFactory, HttpPoolEntry httpPoolEntry) {
        this.manager = clientAsyncConnectionManager;
        this.connFactory = clientAsyncConnectionFactory;
        this.poolEntry = httpPoolEntry;
        this.reusable = true;
        this.duration = Long.MAX_VALUE;
    }

    HttpPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    HttpPoolEntry detach() {
        HttpPoolEntry httpPoolEntry = this.poolEntry;
        this.poolEntry = null;
        return httpPoolEntry;
    }

    public ClientAsyncConnectionManager getManager() {
        return this.manager;
    }

    private ClientAsyncConnection getConnection() {
        HttpPoolEntry httpPoolEntry = this.poolEntry;
        if (httpPoolEntry == null) {
            return null;
        }
        IOSession iOSession = (IOSession)httpPoolEntry.getConnection();
        return (ClientAsyncConnection)iOSession.getAttribute("http.connection");
    }

    private ClientAsyncConnection ensureConnection() {
        HttpPoolEntry httpPoolEntry = this.poolEntry;
        if (httpPoolEntry == null) {
            throw new ConnectionShutdownException();
        }
        IOSession iOSession = (IOSession)httpPoolEntry.getConnection();
        return (ClientAsyncConnection)iOSession.getAttribute("http.connection");
    }

    private HttpPoolEntry ensurePoolEntry() {
        HttpPoolEntry httpPoolEntry = this.poolEntry;
        if (httpPoolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return httpPoolEntry;
    }

    @Override
    public void close() throws IOException {
        ClientAsyncConnection clientAsyncConnection = this.getConnection();
        if (clientAsyncConnection != null) {
            clientAsyncConnection.close();
        }
    }

    @Override
    public void shutdown() throws IOException {
        ClientAsyncConnection clientAsyncConnection = this.getConnection();
        if (clientAsyncConnection != null) {
            clientAsyncConnection.shutdown();
        }
    }

    @Override
    public boolean isOpen() {
        ClientAsyncConnection clientAsyncConnection = this.getConnection();
        if (clientAsyncConnection != null) {
            return clientAsyncConnection.isOpen();
        }
        return false;
    }

    @Override
    public boolean isStale() {
        return this.isOpen();
    }

    @Override
    public void setSocketTimeout(int n) {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.setSocketTimeout(n);
    }

    @Override
    public int getSocketTimeout() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getSocketTimeout();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getMetrics();
    }

    @Override
    public InetAddress getLocalAddress() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getRemotePort();
    }

    @Override
    public int getStatus() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getStatus();
    }

    @Override
    public HttpRequest getHttpRequest() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getHttpRequest();
    }

    @Override
    public HttpResponse getHttpResponse() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getHttpResponse();
    }

    @Override
    public HttpContext getContext() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getContext();
    }

    @Override
    public void requestInput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.requestInput();
    }

    @Override
    public void suspendInput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.suspendInput();
    }

    @Override
    public void requestOutput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.requestOutput();
    }

    @Override
    public void suspendOutput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.suspendOutput();
    }

    @Override
    public void submitRequest(HttpRequest httpRequest) throws IOException, HttpException {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.submitRequest(httpRequest);
    }

    @Override
    public boolean isRequestSubmitted() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.isRequestSubmitted();
    }

    @Override
    public void resetOutput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.resetOutput();
    }

    @Override
    public void resetInput() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        clientAsyncConnection.resetInput();
    }

    @Override
    public boolean isSecure() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        return clientAsyncConnection.getIOSession() instanceof SSLIOSession;
    }

    @Override
    public HttpRoute getRoute() {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        return httpPoolEntry.getEffectiveRoute();
    }

    @Override
    public SSLSession getSSLSession() {
        ClientAsyncConnection clientAsyncConnection = this.ensureConnection();
        IOSession iOSession = clientAsyncConnection.getIOSession();
        if (iOSession instanceof SSLIOSession) {
            return ((SSLIOSession)iOSession).getSSLSession();
        }
        return null;
    }

    @Override
    public Object getState() {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        return httpPoolEntry.getState();
    }

    @Override
    public void setState(Object object) {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        httpPoolEntry.setState(object);
    }

    @Override
    public void markReusable() {
        this.reusable = true;
    }

    @Override
    public void unmarkReusable() {
        this.reusable = false;
    }

    @Override
    public boolean isMarkedReusable() {
        return this.reusable;
    }

    @Override
    public void setIdleDuration(long l, TimeUnit timeUnit) {
        this.duration = l > 0L ? timeUnit.toMillis(l) : -1L;
    }

    private AsyncSchemeRegistry getSchemeRegistry(HttpContext httpContext) {
        AsyncSchemeRegistry asyncSchemeRegistry = (AsyncSchemeRegistry)httpContext.getAttribute("http.scheme-registry");
        if (asyncSchemeRegistry == null) {
            asyncSchemeRegistry = this.manager.getSchemeRegistry();
        }
        return asyncSchemeRegistry;
    }

    @Override
    public synchronized void open(HttpRoute httpRoute, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Object object;
        LayeringStrategy layeringStrategy;
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        RouteTracker routeTracker = httpPoolEntry.getTracker();
        if (routeTracker.isConnected()) {
            throw new IllegalStateException("Connection already open");
        }
        HttpHost httpHost = httpRoute.getTargetHost();
        HttpHost httpHost2 = httpRoute.getProxyHost();
        IOSession iOSession = (IOSession)httpPoolEntry.getConnection();
        if (httpHost2 == null && (layeringStrategy = ((AsyncScheme)(object = this.getSchemeRegistry(httpContext).getScheme(httpHost))).getLayeringStrategy()) != null) {
            iOSession = layeringStrategy.layer(iOSession);
        }
        object = this.connFactory.create("http-outgoing-" + httpPoolEntry.getId(), iOSession, httpParams);
        iOSession.setAttribute("http.connection", object);
        if (httpHost2 == null) {
            routeTracker.connectTarget(object.getIOSession() instanceof SSLIOSession);
        } else {
            routeTracker.connectProxy(httpHost2, false);
        }
    }

    @Override
    public synchronized void tunnelProxy(HttpHost httpHost, HttpParams httpParams) throws IOException {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        RouteTracker routeTracker = httpPoolEntry.getTracker();
        if (!routeTracker.isConnected()) {
            throw new IllegalStateException("Connection not open");
        }
        routeTracker.tunnelProxy(httpHost, false);
    }

    @Override
    public synchronized void tunnelTarget(HttpParams httpParams) throws IOException {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        RouteTracker routeTracker = httpPoolEntry.getTracker();
        if (!routeTracker.isConnected()) {
            throw new IllegalStateException("Connection not open");
        }
        if (routeTracker.isTunnelled()) {
            throw new IllegalStateException("Connection is already tunnelled");
        }
        routeTracker.tunnelTarget(false);
    }

    @Override
    public synchronized void layerProtocol(HttpContext httpContext, HttpParams httpParams) throws IOException {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        RouteTracker routeTracker = httpPoolEntry.getTracker();
        if (!routeTracker.isConnected()) {
            throw new IllegalStateException("Connection not open");
        }
        if (!routeTracker.isTunnelled()) {
            throw new IllegalStateException("Protocol layering without a tunnel not supported");
        }
        if (routeTracker.isLayered()) {
            throw new IllegalStateException("Multiple protocol layering not supported");
        }
        HttpHost httpHost = routeTracker.getTargetHost();
        AsyncScheme asyncScheme = this.getSchemeRegistry(httpContext).getScheme(httpHost);
        LayeringStrategy layeringStrategy = asyncScheme.getLayeringStrategy();
        if (layeringStrategy == null) {
            throw new IllegalStateException(asyncScheme.getName() + " scheme does not provider support for protocol layering");
        }
        IOSession iOSession = (IOSession)httpPoolEntry.getConnection();
        ClientAsyncConnection clientAsyncConnection = (ClientAsyncConnection)iOSession.getAttribute("http.connection");
        clientAsyncConnection.upgrade((SSLIOSession)layeringStrategy.layer(iOSession));
        routeTracker.layerProtocol(layeringStrategy.isSecure());
    }

    @Override
    public synchronized void releaseConnection() {
        if (this.poolEntry == null) {
            return;
        }
        this.manager.releaseConnection(this, this.duration, TimeUnit.MILLISECONDS);
        this.poolEntry = null;
    }

    @Override
    public synchronized void abortConnection() {
        if (this.poolEntry == null) {
            return;
        }
        this.reusable = false;
        IOSession iOSession = (IOSession)this.poolEntry.getConnection();
        ClientAsyncConnection clientAsyncConnection = (ClientAsyncConnection)iOSession.getAttribute("http.connection");
        try {
            clientAsyncConnection.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.manager.releaseConnection(this, this.duration, TimeUnit.MILLISECONDS);
        this.poolEntry = null;
    }

    public synchronized String toString() {
        if (this.poolEntry != null) {
            return this.poolEntry.toString();
        }
        return "released";
    }
}

