/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.conn.LoggingIOSession;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;

class ManagedNHttpClientConnectionImpl
extends DefaultNHttpClientConnection
implements ManagedNHttpClientConnection {
    private final Log headerlog;
    private final Log wirelog;
    private final Log log;
    private final String id;
    private IOSession original;

    public ManagedNHttpClientConnectionImpl(String string, Log log, Log log2, Log log3, IOSession iOSession, int n, int n2, ByteBufferAllocator byteBufferAllocator, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory) {
        super(iOSession, n, n2, byteBufferAllocator, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy, contentLengthStrategy2, nHttpMessageWriterFactory, nHttpMessageParserFactory);
        this.id = string;
        this.log = log;
        this.headerlog = log2;
        this.wirelog = log3;
        this.original = iOSession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            super.bind(new LoggingIOSession(iOSession, this.id, this.log, this.wirelog));
        }
    }

    @Override
    public void bind(IOSession iOSession) {
        Args.notNull((Object)iOSession, (String)"I/O session");
        Asserts.check((!iOSession.isClosed() ? 1 : 0) != 0, (String)"I/O session is closed");
        this.status = 0;
        this.original = iOSession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " Upgrade session " + iOSession));
            super.bind(new LoggingIOSession(iOSession, this.id, this.log, this.wirelog));
        } else {
            super.bind(iOSession);
        }
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    @Override
    public SSLSession getSSLSession() {
        if (this.original instanceof SSLIOSession) {
            return ((SSLIOSession)this.original).getSSLSession();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected void onResponseReceived(HttpResponse httpResponse) {
        if (httpResponse != null && this.headerlog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerlog.debug((Object)(this.id + " << " + httpResponse.getStatusLine().toString()));
            for (Header header : headerArray = httpResponse.getAllHeaders()) {
                this.headerlog.debug((Object)(this.id + " << " + header.toString()));
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest httpRequest) {
        if (httpRequest != null && this.headerlog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerlog.debug((Object)(this.id + " >> " + httpRequest.getRequestLine().toString()));
            for (Header header : headerArray = httpRequest.getAllHeaders()) {
                this.headerlog.debug((Object)(this.id + " >> " + header.toString()));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append(" [");
        switch (this.status) {
            case 0: {
                stringBuilder.append("ACTIVE");
                if (!this.inbuf.hasData()) break;
                stringBuilder.append("(").append(this.inbuf.length()).append(")");
                break;
            }
            case 1: {
                stringBuilder.append("CLOSING");
                break;
            }
            case 2: {
                stringBuilder.append("CLOSED");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

