/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import com.icbc.api.internal.apache.http.impl.nio.conn.DefaultClientAsyncConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.conn.HttpNIOConnPool;
import com.icbc.api.internal.apache.http.impl.nio.conn.HttpPoolEntry;
import com.icbc.api.internal.apache.http.impl.nio.conn.ManagedClientAsyncConnectionImpl;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionFactory;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.ManagedClientAsyncConnection;
import com.icbc.api.internal.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.pool.ConnPoolControl;
import com.icbc.api.internal.apache.http.pool.PoolStats;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class PoolingClientAsyncConnectionManager
implements ClientAsyncConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConnectingIOReactor ioreactor;
    private final HttpNIOConnPool pool;
    private final AsyncSchemeRegistry schemeRegistry;
    private final ClientAsyncConnectionFactory connFactory;

    public PoolingClientAsyncConnectionManager(ConnectingIOReactor connectingIOReactor, AsyncSchemeRegistry asyncSchemeRegistry, long l, TimeUnit timeUnit) {
        Args.notNull((Object)connectingIOReactor, (String)"I/O reactor");
        Args.notNull((Object)asyncSchemeRegistry, (String)"Scheme registory");
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        this.ioreactor = connectingIOReactor;
        this.pool = new HttpNIOConnPool(this.log, connectingIOReactor, asyncSchemeRegistry, l, timeUnit);
        this.schemeRegistry = asyncSchemeRegistry;
        this.connFactory = this.createClientAsyncConnectionFactory();
    }

    public PoolingClientAsyncConnectionManager(ConnectingIOReactor connectingIOReactor, AsyncSchemeRegistry asyncSchemeRegistry) throws IOReactorException {
        this(connectingIOReactor, asyncSchemeRegistry, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingClientAsyncConnectionManager(ConnectingIOReactor connectingIOReactor) throws IOReactorException {
        this(connectingIOReactor, AsyncSchemeRegistryFactory.createDefault());
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    protected ClientAsyncConnectionFactory createClientAsyncConnectionFactory() {
        return new DefaultClientAsyncConnectionFactory();
    }

    @Override
    public AsyncSchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    @Override
    public void execute(IOEventDispatch iOEventDispatch) throws IOException {
        this.ioreactor.execute(iOEventDispatch);
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioreactor.getStatus();
    }

    @Override
    public void shutdown(long l) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(l);
        this.log.debug((Object)"Connection manager shut down");
    }

    @Override
    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    private String format(HttpRoute httpRoute, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ").append(httpRoute).append("]");
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    private String formatStats(HttpRoute httpRoute) {
        StringBuilder stringBuilder = new StringBuilder();
        PoolStats poolStats = this.pool.getTotalStats();
        PoolStats poolStats2 = this.pool.getStats(httpRoute);
        stringBuilder.append("[total kept alive: ").append(poolStats.getAvailable()).append("; ");
        stringBuilder.append("route allocated: ").append(poolStats2.getLeased() + poolStats2.getAvailable());
        stringBuilder.append(" of ").append(poolStats2.getMax()).append("; ");
        stringBuilder.append("total allocated: ").append(poolStats.getLeased() + poolStats.getAvailable());
        stringBuilder.append(" of ").append(poolStats.getMax()).append("]");
        return stringBuilder.toString();
    }

    private String format(HttpPoolEntry httpPoolEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id: ").append(httpPoolEntry.getId()).append("]");
        stringBuilder.append("[route: ").append(httpPoolEntry.getRoute()).append("]");
        Object object = httpPoolEntry.getState();
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public Future<ManagedClientAsyncConnection> leaseConnection(HttpRoute httpRoute, Object object, long l, TimeUnit timeUnit, FutureCallback<ManagedClientAsyncConnection> futureCallback) {
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(httpRoute, object) + this.formatStats(httpRoute)));
        }
        BasicFuture<ManagedClientAsyncConnection> basicFuture = new BasicFuture<ManagedClientAsyncConnection>(futureCallback);
        this.pool.lease(httpRoute, object, l, timeUnit, new InternalPoolEntryCallback(basicFuture));
        return basicFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(ManagedClientAsyncConnection managedClientAsyncConnection, long l, TimeUnit timeUnit) {
        Args.notNull((Object)managedClientAsyncConnection, (String)"HTTP connection");
        if (!(managedClientAsyncConnection instanceof ManagedClientAsyncConnectionImpl)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager");
        }
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        ManagedClientAsyncConnectionImpl managedClientAsyncConnectionImpl = (ManagedClientAsyncConnectionImpl)managedClientAsyncConnection;
        ClientAsyncConnectionManager clientAsyncConnectionManager = managedClientAsyncConnectionImpl.getManager();
        if (clientAsyncConnectionManager != null && clientAsyncConnectionManager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager");
        }
        if (this.pool.isShutdown()) {
            return;
        }
        ManagedClientAsyncConnectionImpl managedClientAsyncConnectionImpl2 = managedClientAsyncConnectionImpl;
        synchronized (managedClientAsyncConnectionImpl2) {
            HttpPoolEntry httpPoolEntry = managedClientAsyncConnectionImpl.getPoolEntry();
            if (httpPoolEntry == null) {
                return;
            }
            try {
                block16: {
                    if (managedClientAsyncConnectionImpl.isOpen() && !managedClientAsyncConnectionImpl.isMarkedReusable()) {
                        try {
                            managedClientAsyncConnectionImpl.shutdown();
                        }
                        catch (IOException iOException) {
                            if (!this.log.isDebugEnabled()) break block16;
                            this.log.debug((Object)"I/O exception shutting down released connection", (Throwable)iOException);
                        }
                    }
                }
                if (managedClientAsyncConnectionImpl.isOpen()) {
                    httpPoolEntry.updateExpiry(l, timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS);
                    if (this.log.isDebugEnabled()) {
                        String string = l > 0L ? "for " + l + " " + (Object)((Object)timeUnit) : "indefinitely";
                        this.log.debug((Object)("Connection " + this.format(httpPoolEntry) + " can be kept alive " + string));
                    }
                    managedClientAsyncConnectionImpl.setSocketTimeout(0);
                }
            }
            finally {
                this.pool.release(managedClientAsyncConnectionImpl.detach(), managedClientAsyncConnectionImpl.isMarkedReusable());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(httpPoolEntry) + this.formatStats((HttpRoute)httpPoolEntry.getRoute())));
            }
        }
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute httpRoute) {
        return this.pool.getStats(httpRoute);
    }

    @Override
    public void setMaxTotal(int n) {
        this.pool.setMaxTotal(n);
    }

    @Override
    public void setDefaultMaxPerRoute(int n) {
        this.pool.setDefaultMaxPerRoute(n);
    }

    @Override
    public void setMaxPerRoute(HttpRoute httpRoute, int n) {
        this.pool.setMaxPerRoute(httpRoute, n);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public int getMaxPerRoute(HttpRoute httpRoute) {
        return this.pool.getMaxPerRoute(httpRoute);
    }

    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + l + " " + (Object)((Object)timeUnit)));
        }
        this.pool.closeIdle(l, timeUnit);
    }

    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    class InternalPoolEntryCallback
    implements FutureCallback<HttpPoolEntry> {
        private final BasicFuture<ManagedClientAsyncConnection> future;

        public InternalPoolEntryCallback(BasicFuture<ManagedClientAsyncConnection> basicFuture) {
            this.future = basicFuture;
        }

        @Override
        public void completed(HttpPoolEntry httpPoolEntry) {
            ManagedClientAsyncConnectionImpl managedClientAsyncConnectionImpl;
            if (PoolingClientAsyncConnectionManager.this.log.isDebugEnabled()) {
                PoolingClientAsyncConnectionManager.this.log.debug((Object)("Connection leased: " + PoolingClientAsyncConnectionManager.this.format(httpPoolEntry) + PoolingClientAsyncConnectionManager.this.formatStats((HttpRoute)httpPoolEntry.getRoute())));
            }
            if (!this.future.completed(managedClientAsyncConnectionImpl = new ManagedClientAsyncConnectionImpl(PoolingClientAsyncConnectionManager.this, PoolingClientAsyncConnectionManager.this.connFactory, httpPoolEntry))) {
                PoolingClientAsyncConnectionManager.this.pool.release(httpPoolEntry, true);
            }
        }

        @Override
        public void failed(Exception exception) {
            if (PoolingClientAsyncConnectionManager.this.log.isDebugEnabled()) {
                PoolingClientAsyncConnectionManager.this.log.debug((Object)"Connection request failed", (Throwable)exception);
            }
            this.future.failed(exception);
        }

        @Override
        public void cancelled() {
            PoolingClientAsyncConnectionManager.this.log.debug((Object)"Connection request cancelled");
            this.future.cancel(true);
        }
    }
}

