/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.config.Lookup;
import com.icbc.api.internal.apache.http.config.Registry;
import com.icbc.api.internal.apache.http.config.RegistryBuilder;
import com.icbc.api.internal.apache.http.conn.DnsResolver;
import com.icbc.api.internal.apache.http.conn.SchemePortResolver;
import com.icbc.api.internal.apache.http.conn.UnsupportedSchemeException;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.icbc.api.internal.apache.http.impl.conn.SystemDefaultDnsResolver;
import com.icbc.api.internal.apache.http.impl.nio.conn.CPool;
import com.icbc.api.internal.apache.http.impl.nio.conn.CPoolEntry;
import com.icbc.api.internal.apache.http.impl.nio.conn.CPoolProxy;
import com.icbc.api.internal.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.conn.NHttpClientConnectionManager;
import com.icbc.api.internal.apache.http.nio.conn.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.conn.NoopIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.conn.SchemeIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import com.icbc.api.internal.apache.http.nio.pool.NIOConnFactory;
import com.icbc.api.internal.apache.http.nio.pool.SocketAddressResolver;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.pool.ConnPoolControl;
import com.icbc.api.internal.apache.http.pool.PoolStats;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class PoolingNHttpClientConnectionManager
implements NHttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    static final String IOSESSION_FACTORY_REGISTRY = "http.iosession-factory-registry";
    private final ConnectingIOReactor ioreactor;
    private final ConfigData configData;
    private final CPool pool;
    private final Registry<SchemeIOSessionStrategy> iosessionFactoryRegistry;

    private static Registry<SchemeIOSessionStrategy> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)SSLIOSessionStrategy.getDefaultStrategy())).build();
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor) {
        this(connectingIOReactor, PoolingNHttpClientConnectionManager.getDefaultRegistry());
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, Registry<SchemeIOSessionStrategy> registry) {
        this(connectingIOReactor, null, registry, null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, NHttpConnectionFactory<ManagedNHttpClientConnection> nHttpConnectionFactory, DnsResolver dnsResolver) {
        this(connectingIOReactor, nHttpConnectionFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), dnsResolver);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, NHttpConnectionFactory<ManagedNHttpClientConnection> nHttpConnectionFactory) {
        this(connectingIOReactor, nHttpConnectionFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, NHttpConnectionFactory<ManagedNHttpClientConnection> nHttpConnectionFactory, Registry<SchemeIOSessionStrategy> registry) {
        this(connectingIOReactor, nHttpConnectionFactory, registry, null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, NHttpConnectionFactory<ManagedNHttpClientConnection> nHttpConnectionFactory, Registry<SchemeIOSessionStrategy> registry, DnsResolver dnsResolver) {
        this(connectingIOReactor, nHttpConnectionFactory, registry, null, dnsResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, NHttpConnectionFactory<ManagedNHttpClientConnection> nHttpConnectionFactory, Registry<SchemeIOSessionStrategy> registry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long l, TimeUnit timeUnit) {
        Args.notNull((Object)connectingIOReactor, (String)"I/O reactor");
        Args.notNull(registry, (String)"I/O session factory registry");
        this.ioreactor = connectingIOReactor;
        this.configData = new ConfigData();
        this.pool = new CPool(connectingIOReactor, new InternalConnectionFactory(this.configData, nHttpConnectionFactory), new InternalAddressResolver(schemePortResolver, dnsResolver), 2, 20, l, timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS);
        this.iosessionFactoryRegistry = registry;
    }

    PoolingNHttpClientConnectionManager(ConnectingIOReactor connectingIOReactor, CPool cPool, Registry<SchemeIOSessionStrategy> registry) {
        this.ioreactor = connectingIOReactor;
        this.configData = new ConfigData();
        this.pool = cPool;
        this.iosessionFactoryRegistry = registry;
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void execute(IOEventDispatch iOEventDispatch) throws IOException {
        this.ioreactor.execute(iOEventDispatch);
    }

    public void shutdown(long l) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(l);
        this.log.debug((Object)"Connection manager shut down");
    }

    @Override
    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    private String format(HttpRoute httpRoute, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ").append(httpRoute).append("]");
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    private String formatStats(HttpRoute httpRoute) {
        StringBuilder stringBuilder = new StringBuilder();
        PoolStats poolStats = this.pool.getTotalStats();
        PoolStats poolStats2 = this.pool.getStats(httpRoute);
        stringBuilder.append("[total kept alive: ").append(poolStats.getAvailable()).append("; ");
        stringBuilder.append("route allocated: ").append(poolStats2.getLeased() + poolStats2.getAvailable());
        stringBuilder.append(" of ").append(poolStats2.getMax()).append("; ");
        stringBuilder.append("total allocated: ").append(poolStats.getLeased() + poolStats.getAvailable());
        stringBuilder.append(" of ").append(poolStats.getMax()).append("]");
        return stringBuilder.toString();
    }

    private String format(CPoolEntry cPoolEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id: ").append(cPoolEntry.getId()).append("]");
        stringBuilder.append("[route: ").append(cPoolEntry.getRoute()).append("]");
        Object object = cPoolEntry.getState();
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public Future<NHttpClientConnection> requestConnection(HttpRoute httpRoute, Object object, long l, long l2, TimeUnit timeUnit, FutureCallback<NHttpClientConnection> futureCallback) {
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(httpRoute, object) + this.formatStats(httpRoute)));
        }
        BasicFuture<NHttpClientConnection> basicFuture = new BasicFuture<NHttpClientConnection>(futureCallback);
        HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        SchemeIOSessionStrategy schemeIOSessionStrategy = this.iosessionFactoryRegistry.lookup(httpHost.getSchemeName());
        if (schemeIOSessionStrategy == null) {
            basicFuture.failed(new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported"));
            return basicFuture;
        }
        this.pool.lease(httpRoute, object, l, l2, timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS, new InternalPoolEntryCallback(basicFuture));
        return basicFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(NHttpClientConnection nHttpClientConnection, Object object, long l, TimeUnit timeUnit) {
        Args.notNull((Object)nHttpClientConnection, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection2 = nHttpClientConnection;
        synchronized (nHttpClientConnection2) {
            NHttpClientConnection nHttpClientConnection3;
            CPoolEntry cPoolEntry;
            block9: {
                cPoolEntry = CPoolProxy.detach(nHttpClientConnection);
                if (cPoolEntry == null) {
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Releasing connection: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute())));
                }
                nHttpClientConnection3 = (NHttpClientConnection)cPoolEntry.getConnection();
                try {
                    if (!nHttpClientConnection3.isOpen()) break block9;
                    cPoolEntry.setState(object);
                    cPoolEntry.updateExpiry(l, timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break block9;
                    String string = l > 0L ? "for " + (double)l / 1000.0 + " seconds" : "indefinitely";
                    this.log.debug((Object)("Connection " + this.format(cPoolEntry) + " can be kept alive " + string));
                }
                catch (Throwable throwable) {
                    this.pool.release(cPoolEntry, nHttpClientConnection3.isOpen() && cPoolEntry.isRouteComplete());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Connection released: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute())));
                    }
                    throw throwable;
                }
            }
            this.pool.release(cPoolEntry, nHttpClientConnection3.isOpen() && cPoolEntry.isRouteComplete());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute())));
            }
        }
    }

    private Lookup<SchemeIOSessionStrategy> getIOSessionFactoryRegistry(HttpContext httpContext) {
        Registry<SchemeIOSessionStrategy> registry = (Registry<SchemeIOSessionStrategy>)httpContext.getAttribute(IOSESSION_FACTORY_REGISTRY);
        if (registry == null) {
            registry = this.iosessionFactoryRegistry;
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRoute(NHttpClientConnection nHttpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
        Args.notNull((Object)nHttpClientConnection, (String)"Managed connection");
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        Lookup<SchemeIOSessionStrategy> lookup = this.getIOSessionFactoryRegistry(httpContext);
        SchemeIOSessionStrategy schemeIOSessionStrategy = lookup.lookup(httpHost.getSchemeName());
        if (schemeIOSessionStrategy == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        if (schemeIOSessionStrategy.isLayeringRequired()) {
            NHttpClientConnection nHttpClientConnection2 = nHttpClientConnection;
            synchronized (nHttpClientConnection2) {
                CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(nHttpClientConnection);
                ManagedNHttpClientConnection managedNHttpClientConnection = (ManagedNHttpClientConnection)cPoolEntry.getConnection();
                IOSession iOSession = managedNHttpClientConnection.getIOSession();
                IOSession iOSession2 = schemeIOSessionStrategy.upgrade(httpHost, iOSession);
                managedNHttpClientConnection.bind(iOSession2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(NHttpClientConnection nHttpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
        Args.notNull((Object)nHttpClientConnection, (String)"Managed connection");
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        HttpHost httpHost = httpRoute.getTargetHost();
        Lookup<SchemeIOSessionStrategy> lookup = this.getIOSessionFactoryRegistry(httpContext);
        SchemeIOSessionStrategy schemeIOSessionStrategy = lookup.lookup(httpHost.getSchemeName());
        if (schemeIOSessionStrategy == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        if (!schemeIOSessionStrategy.isLayeringRequired()) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol does not support connection upgrade");
        }
        NHttpClientConnection nHttpClientConnection2 = nHttpClientConnection;
        synchronized (nHttpClientConnection2) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(nHttpClientConnection);
            ManagedNHttpClientConnection managedNHttpClientConnection = (ManagedNHttpClientConnection)cPoolEntry.getConnection();
            IOSession iOSession = schemeIOSessionStrategy.upgrade(httpHost, managedNHttpClientConnection.getIOSession());
            managedNHttpClientConnection.bind(iOSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeComplete(NHttpClientConnection nHttpClientConnection, HttpRoute httpRoute, HttpContext httpContext) {
        Args.notNull((Object)nHttpClientConnection, (String)"Managed connection");
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        NHttpClientConnection nHttpClientConnection2 = nHttpClientConnection;
        synchronized (nHttpClientConnection2) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(nHttpClientConnection);
            cPoolEntry.markRouteComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRouteComplete(NHttpClientConnection nHttpClientConnection) {
        Args.notNull((Object)nHttpClientConnection, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection2 = nHttpClientConnection;
        synchronized (nHttpClientConnection2) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(nHttpClientConnection);
            return cPoolEntry.isRouteComplete();
        }
    }

    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + l + " " + (Object)((Object)timeUnit)));
        }
        this.pool.closeIdle(l, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setMaxTotal(int n) {
        this.pool.setMaxTotal(n);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setDefaultMaxPerRoute(int n) {
        this.pool.setDefaultMaxPerRoute(n);
    }

    @Override
    public int getMaxPerRoute(HttpRoute httpRoute) {
        return this.pool.getMaxPerRoute(httpRoute);
    }

    @Override
    public void setMaxPerRoute(HttpRoute httpRoute, int n) {
        this.pool.setMaxPerRoute(httpRoute, n);
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute httpRoute) {
        return this.pool.getStats(httpRoute);
    }

    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    public ConnectionConfig getDefaultConnectionConfig() {
        return this.configData.getDefaultConnectionConfig();
    }

    public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.configData.setDefaultConnectionConfig(connectionConfig);
    }

    public ConnectionConfig getConnectionConfig(HttpHost httpHost) {
        return this.configData.getConnectionConfig(httpHost);
    }

    public void setConnectionConfig(HttpHost httpHost, ConnectionConfig connectionConfig) {
        this.configData.setConnectionConfig(httpHost, connectionConfig);
    }

    static class InternalAddressResolver
    implements SocketAddressResolver<HttpRoute> {
        private final SchemePortResolver schemePortResolver;
        private final DnsResolver dnsResolver;

        public InternalAddressResolver(SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
            this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
            this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
        }

        @Override
        public SocketAddress resolveLocalAddress(HttpRoute httpRoute) throws IOException {
            return httpRoute.getLocalAddress() != null ? new InetSocketAddress(httpRoute.getLocalAddress(), 0) : null;
        }

        @Override
        public SocketAddress resolveRemoteAddress(HttpRoute httpRoute) throws IOException {
            HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
            int n = this.schemePortResolver.resolve(httpHost);
            InetAddress[] inetAddressArray = this.dnsResolver.resolve(httpHost.getHostName());
            return new InetSocketAddress(inetAddressArray[0], n);
        }
    }

    static class InternalConnectionFactory
    implements NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> {
        private final ConfigData configData;
        private final NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory;

        InternalConnectionFactory(ConfigData configData, NHttpConnectionFactory<ManagedNHttpClientConnection> managedNHttpClientConnectionFactory) {
            this.configData = configData != null ? configData : new ConfigData();
            this.connFactory = managedNHttpClientConnectionFactory != null ? managedNHttpClientConnectionFactory : ManagedNHttpClientConnectionFactory.INSTANCE;
        }

        @Override
        public ManagedNHttpClientConnection create(HttpRoute httpRoute, IOSession iOSession) throws IOException {
            ConnectionConfig connectionConfig = null;
            if (httpRoute.getProxyHost() != null) {
                connectionConfig = this.configData.getConnectionConfig(httpRoute.getProxyHost());
            }
            if (connectionConfig == null) {
                connectionConfig = this.configData.getConnectionConfig(httpRoute.getTargetHost());
            }
            if (connectionConfig == null) {
                connectionConfig = this.configData.getDefaultConnectionConfig();
            }
            if (connectionConfig == null) {
                connectionConfig = ConnectionConfig.DEFAULT;
            }
            ManagedNHttpClientConnection managedNHttpClientConnection = this.connFactory.create(iOSession, connectionConfig);
            iOSession.setAttribute("http.connection", managedNHttpClientConnection);
            return managedNHttpClientConnection;
        }
    }

    static class ConfigData {
        private final Map<HttpHost, ConnectionConfig> connectionConfigMap = new ConcurrentHashMap<HttpHost, ConnectionConfig>();
        private volatile ConnectionConfig defaultConnectionConfig;

        ConfigData() {
        }

        public ConnectionConfig getDefaultConnectionConfig() {
            return this.defaultConnectionConfig;
        }

        public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
            this.defaultConnectionConfig = connectionConfig;
        }

        public ConnectionConfig getConnectionConfig(HttpHost httpHost) {
            return this.connectionConfigMap.get(httpHost);
        }

        public void setConnectionConfig(HttpHost httpHost, ConnectionConfig connectionConfig) {
            this.connectionConfigMap.put(httpHost, connectionConfig);
        }
    }

    class InternalPoolEntryCallback
    implements FutureCallback<CPoolEntry> {
        private final BasicFuture<NHttpClientConnection> future;

        public InternalPoolEntryCallback(BasicFuture<NHttpClientConnection> basicFuture) {
            this.future = basicFuture;
        }

        @Override
        public void completed(CPoolEntry cPoolEntry) {
            NHttpClientConnection nHttpClientConnection;
            Asserts.check((cPoolEntry.getConnection() != null ? 1 : 0) != 0, (String)"Pool entry with no connection");
            if (PoolingNHttpClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingNHttpClientConnectionManager.this.log.debug((Object)("Connection leased: " + PoolingNHttpClientConnectionManager.this.format(cPoolEntry) + PoolingNHttpClientConnectionManager.this.formatStats((HttpRoute)cPoolEntry.getRoute())));
            }
            if (!this.future.completed(nHttpClientConnection = CPoolProxy.newProxy(cPoolEntry))) {
                PoolingNHttpClientConnectionManager.this.pool.release(cPoolEntry, true);
            }
        }

        @Override
        public void failed(Exception exception) {
            if (PoolingNHttpClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingNHttpClientConnectionManager.this.log.debug((Object)"Connection request failed", (Throwable)exception);
            }
            this.future.failed(exception);
        }

        @Override
        public void cancelled() {
            PoolingNHttpClientConnectionManager.this.log.debug((Object)"Connection request cancelled");
            this.future.cancel(true);
        }
    }
}

