/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.conn;

import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;

class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log, String string) {
        this.log = log;
        this.id = string;
    }

    private void wire(String string, byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            if (by == 13) {
                stringBuilder.append("[\\r]");
                continue;
            }
            if (by == 10) {
                stringBuilder.append("[\\n]\"");
                stringBuilder.insert(0, "\"");
                stringBuilder.insert(0, string);
                this.log.debug((Object)(this.id + " " + stringBuilder.toString()));
                stringBuilder.setLength(0);
                continue;
            }
            if (by < 32 || by > 127) {
                stringBuilder.append("[0x");
                stringBuilder.append(Integer.toHexString(by));
                stringBuilder.append("]");
                continue;
            }
            stringBuilder.append((char)by);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\"');
            stringBuilder.insert(0, '\"');
            stringBuilder.insert(0, string);
            this.log.debug((Object)(this.id + " " + stringBuilder.toString()));
        }
    }

    public boolean isEnabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] byArray, int n, int n2) {
        this.wire(">> ", byArray, n, n2);
    }

    public void input(byte[] byArray, int n, int n2) {
        this.wire("<< ", byArray, n, n2);
    }

    public void output(byte[] byArray) {
        this.output(byArray, 0, byArray.length);
    }

    public void input(byte[] byArray) {
        this.input(byArray, 0, byArray.length);
    }

    public void output(int n) {
        this.output(new byte[]{(byte)n});
    }

    public void input(int n) {
        this.input(new byte[]{(byte)n});
    }

    public void output(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.output(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.output(byArray);
        }
    }

    public void input(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.input(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.input(byArray);
        }
    }
}

