/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;

public abstract class AbstractIODispatch<T>
implements IOEventDispatch {
    protected abstract T createConnection(IOSession var1);

    protected abstract void onConnected(T var1);

    protected abstract void onClosed(T var1);

    protected abstract void onException(T var1, IOException var2);

    protected abstract void onInputReady(T var1);

    protected abstract void onOutputReady(T var1);

    protected abstract void onTimeout(T var1);

    private void ensureNotNull(T t) {
        Asserts.notNull(t, (String)"HTTP connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(IOSession iOSession) {
        block9: {
            Object object = iOSession.getAttribute("http.connection");
            try {
                if (object == null) {
                    object = this.createConnection(iOSession);
                    iOSession.setAttribute("http.connection", object);
                }
                this.onConnected(object);
                SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute("http.session.ssl");
                if (sSLIOSession == null) break block9;
                try {
                    SSLIOSession sSLIOSession2 = sSLIOSession;
                    synchronized (sSLIOSession2) {
                        if (!sSLIOSession.isInitialized()) {
                            sSLIOSession.initialize();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.onException(object, iOException);
                    sSLIOSession.shutdown();
                }
            }
            catch (RuntimeException runtimeException) {
                iOSession.shutdown();
                throw runtimeException;
            }
        }
    }

    @Override
    public void disconnected(IOSession iOSession) {
        Object object = iOSession.getAttribute("http.connection");
        if (object != null) {
            this.onClosed(object);
        }
    }

    @Override
    public void inputReady(IOSession iOSession) {
        Object object = iOSession.getAttribute("http.connection");
        try {
            this.ensureNotNull(object);
            SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute("http.session.ssl");
            if (sSLIOSession == null) {
                this.onInputReady(object);
            } else {
                try {
                    if (!sSLIOSession.isInitialized()) {
                        sSLIOSession.initialize();
                    }
                    if (sSLIOSession.isAppInputReady()) {
                        this.onInputReady(object);
                    }
                    sSLIOSession.inboundTransport();
                }
                catch (IOException iOException) {
                    this.onException(object, iOException);
                    sSLIOSession.shutdown();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            iOSession.shutdown();
            throw runtimeException;
        }
    }

    @Override
    public void outputReady(IOSession iOSession) {
        Object object = iOSession.getAttribute("http.connection");
        try {
            this.ensureNotNull(object);
            SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute("http.session.ssl");
            if (sSLIOSession == null) {
                this.onOutputReady(object);
            } else {
                try {
                    if (!sSLIOSession.isInitialized()) {
                        sSLIOSession.initialize();
                    }
                    if (sSLIOSession.isAppOutputReady()) {
                        this.onOutputReady(object);
                    }
                    sSLIOSession.outboundTransport();
                }
                catch (IOException iOException) {
                    this.onException(object, iOException);
                    sSLIOSession.shutdown();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            iOSession.shutdown();
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(IOSession iOSession) {
        block6: {
            Object object = iOSession.getAttribute("http.connection");
            try {
                SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute("http.session.ssl");
                this.ensureNotNull(object);
                this.onTimeout(object);
                if (sSLIOSession == null) break block6;
                SSLIOSession sSLIOSession2 = sSLIOSession;
                synchronized (sSLIOSession2) {
                    if (sSLIOSession.isOutboundDone() && !sSLIOSession.isInboundDone()) {
                        sSLIOSession.shutdown();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                iOSession.shutdown();
                throw runtimeException;
            }
        }
    }
}

