/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorExceptionHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BaseIOReactor
extends AbstractIOReactor {
    private final long timeoutCheckInterval;
    private final Set<IOSession> bufferingSessions = new HashSet<IOSession>();
    private long lastTimeoutCheck;
    private IOReactorExceptionHandler exceptionHandler = null;
    private IOEventDispatch eventDispatch = null;

    public BaseIOReactor(long l) throws IOReactorException {
        this(l, false);
    }

    public BaseIOReactor(long l, boolean bl) throws IOReactorException {
        super(l, bl);
        this.timeoutCheckInterval = l;
        this.lastTimeoutCheck = System.currentTimeMillis();
    }

    @Override
    public void execute(IOEventDispatch iOEventDispatch) throws InterruptedIOException, IOReactorException {
        Args.notNull((Object)iOEventDispatch, (String)"Event dispatcher");
        this.eventDispatch = iOEventDispatch;
        this.execute();
    }

    public void setExceptionHandler(IOReactorExceptionHandler iOReactorExceptionHandler) {
        this.exceptionHandler = iOReactorExceptionHandler;
    }

    protected void handleRuntimeException(RuntimeException runtimeException) {
        if (this.exceptionHandler == null || !this.exceptionHandler.handle(runtimeException)) {
            throw runtimeException;
        }
    }

    @Override
    protected void acceptable(SelectionKey selectionKey) {
    }

    @Override
    protected void connectable(SelectionKey selectionKey) {
    }

    @Override
    protected void readable(SelectionKey selectionKey) {
        IOSession iOSession = this.getSession(selectionKey);
        try {
            for (int i = 0; i < 5; ++i) {
                this.eventDispatch.inputReady(iOSession);
                if (!iOSession.hasBufferedInput() || (iOSession.getEventMask() & 1) == 0) break;
            }
            if (iOSession.hasBufferedInput()) {
                this.bufferingSessions.add(iOSession);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.queueClosedSession(iOSession);
            selectionKey.attach(null);
        }
        catch (RuntimeException runtimeException) {
            this.handleRuntimeException(runtimeException);
        }
    }

    @Override
    protected void writable(SelectionKey selectionKey) {
        IOSession iOSession = this.getSession(selectionKey);
        try {
            this.eventDispatch.outputReady(iOSession);
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.queueClosedSession(iOSession);
            selectionKey.attach(null);
        }
        catch (RuntimeException runtimeException) {
            this.handleRuntimeException(runtimeException);
        }
    }

    @Override
    protected void validate(Set<SelectionKey> set) {
        long l = System.currentTimeMillis();
        if (l - this.lastTimeoutCheck >= this.timeoutCheckInterval) {
            this.lastTimeoutCheck = l;
            if (set != null) {
                for (SelectionKey object : set) {
                    this.timeoutCheck(object, l);
                }
            }
        }
        if (!this.bufferingSessions.isEmpty()) {
            Iterator<Object> iterator = this.bufferingSessions.iterator();
            while (iterator.hasNext()) {
                IOSession iOSession = (IOSession)iterator.next();
                if (!iOSession.hasBufferedInput()) {
                    iterator.remove();
                    continue;
                }
                try {
                    if ((iOSession.getEventMask() & 1) <= 0) continue;
                    this.eventDispatch.inputReady(iOSession);
                    if (iOSession.hasBufferedInput()) continue;
                    iterator.remove();
                }
                catch (CancelledKeyException cancelledKeyException) {
                    iterator.remove();
                    this.queueClosedSession(iOSession);
                }
                catch (RuntimeException runtimeException) {
                    this.handleRuntimeException(runtimeException);
                }
            }
        }
    }

    @Override
    protected void sessionCreated(SelectionKey selectionKey, IOSession iOSession) {
        try {
            this.eventDispatch.connected(iOSession);
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.queueClosedSession(iOSession);
        }
        catch (RuntimeException runtimeException) {
            this.handleRuntimeException(runtimeException);
        }
    }

    @Override
    protected void sessionTimedOut(IOSession iOSession) {
        try {
            this.eventDispatch.timeout(iOSession);
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.queueClosedSession(iOSession);
        }
        catch (RuntimeException runtimeException) {
            this.handleRuntimeException(runtimeException);
        }
    }

    @Override
    protected void sessionClosed(IOSession iOSession) {
        try {
            this.eventDispatch.disconnected(iOSession);
        }
        catch (CancelledKeyException cancelledKeyException) {
        }
        catch (RuntimeException runtimeException) {
            this.handleRuntimeException(runtimeException);
        }
    }
}

