/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ChannelEntry;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ListenerEndpointClosedCallback;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ListenerEndpointImpl;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.nio.reactor.ListenerEndpoint;
import com.icbc.api.internal.apache.http.nio.reactor.ListeningIOReactor;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;

public class DefaultListeningIOReactor
extends AbstractMultiworkerIOReactor
implements ListeningIOReactor {
    private final Queue<ListenerEndpointImpl> requestQueue = new ConcurrentLinkedQueue<ListenerEndpointImpl>();
    private final Set<ListenerEndpointImpl> endpoints = Collections.synchronizedSet(new HashSet());
    private final Set<SocketAddress> pausedEndpoints = new HashSet<SocketAddress>();
    private volatile boolean paused;

    public DefaultListeningIOReactor(IOReactorConfig iOReactorConfig, ThreadFactory threadFactory) throws IOReactorException {
        super(iOReactorConfig, threadFactory);
    }

    public DefaultListeningIOReactor(IOReactorConfig iOReactorConfig) throws IOReactorException {
        this(iOReactorConfig, null);
    }

    public DefaultListeningIOReactor() throws IOReactorException {
        this(null, null);
    }

    @Deprecated
    public DefaultListeningIOReactor(int n, ThreadFactory threadFactory, HttpParams httpParams) throws IOReactorException {
        this(DefaultListeningIOReactor.convert(n, httpParams), threadFactory);
    }

    @Deprecated
    public DefaultListeningIOReactor(int n, HttpParams httpParams) throws IOReactorException {
        this(DefaultListeningIOReactor.convert(n, httpParams), null);
    }

    @Override
    protected void cancelRequests() throws IOReactorException {
        ListenerEndpointImpl listenerEndpointImpl;
        while ((listenerEndpointImpl = this.requestQueue.poll()) != null) {
            listenerEndpointImpl.cancel();
        }
    }

    @Override
    protected void processEvents(int n) throws IOReactorException {
        if (!this.paused) {
            this.processSessionRequests();
        }
        if (n > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            for (SelectionKey selectionKey : set) {
                this.processEvent(selectionKey);
            }
            set.clear();
        }
    }

    private void processEvent(SelectionKey selectionKey) throws IOReactorException {
        block7: {
            try {
                if (!selectionKey.isAcceptable()) break block7;
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                while (true) {
                    SocketChannel socketChannel;
                    block9: {
                        block8: {
                            socketChannel = null;
                            try {
                                socketChannel = serverSocketChannel.accept();
                            }
                            catch (IOException iOException) {
                                if (this.exceptionHandler != null && this.exceptionHandler.handle(iOException)) break block8;
                                throw new IOReactorException("Failure accepting connection", iOException);
                            }
                        }
                        if (socketChannel == null) break block7;
                        try {
                            this.prepareSocket(socketChannel.socket());
                        }
                        catch (IOException iOException) {
                            if (this.exceptionHandler != null && this.exceptionHandler.handle(iOException)) break block9;
                            throw new IOReactorException("Failure initalizing socket", iOException);
                        }
                    }
                    ChannelEntry channelEntry = new ChannelEntry(socketChannel);
                    this.addChannel(channelEntry);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                ListenerEndpoint listenerEndpoint = (ListenerEndpoint)selectionKey.attachment();
                this.endpoints.remove(listenerEndpoint);
                selectionKey.attach(null);
            }
        }
    }

    private ListenerEndpointImpl createEndpoint(SocketAddress socketAddress) {
        return new ListenerEndpointImpl(socketAddress, new ListenerEndpointClosedCallback(){

            @Override
            public void endpointClosed(ListenerEndpoint listenerEndpoint) {
                DefaultListeningIOReactor.this.endpoints.remove(listenerEndpoint);
            }
        });
    }

    @Override
    public ListenerEndpoint listen(SocketAddress socketAddress) {
        Asserts.check((this.status.compareTo((Enum)IOReactorStatus.ACTIVE) <= 0 ? 1 : 0) != 0, (String)"I/O reactor has been shut down");
        ListenerEndpointImpl listenerEndpointImpl = this.createEndpoint(socketAddress);
        this.requestQueue.add(listenerEndpointImpl);
        this.selector.wakeup();
        return listenerEndpointImpl;
    }

    private void processSessionRequests() throws IOReactorException {
        ListenerEndpointImpl listenerEndpointImpl;
        while ((listenerEndpointImpl = this.requestQueue.poll()) != null) {
            Object object;
            ServerSocketChannel serverSocketChannel;
            SocketAddress socketAddress = listenerEndpointImpl.getAddress();
            try {
                serverSocketChannel = ServerSocketChannel.open();
            }
            catch (IOException iOException) {
                throw new IOReactorException("Failure opening server socket", iOException);
            }
            try {
                object = serverSocketChannel.socket();
                ((ServerSocket)object).setReuseAddress(this.config.isSoReuseAddress());
                if (this.config.getSoTimeout() > 0) {
                    ((ServerSocket)object).setSoTimeout(this.config.getSoTimeout());
                }
                if (this.config.getRcvBufSize() > 0) {
                    ((ServerSocket)object).setReceiveBufferSize(this.config.getRcvBufSize());
                }
                serverSocketChannel.configureBlocking(false);
                ((ServerSocket)object).bind(socketAddress, this.config.getBacklogSize());
            }
            catch (IOException iOException) {
                DefaultListeningIOReactor.closeChannel(serverSocketChannel);
                listenerEndpointImpl.failed(iOException);
                if (this.exceptionHandler == null || !this.exceptionHandler.handle(iOException)) {
                    throw new IOReactorException("Failure binding socket to address " + socketAddress, iOException);
                }
                return;
            }
            try {
                object = serverSocketChannel.register(this.selector, 16);
                ((SelectionKey)object).attach(listenerEndpointImpl);
                listenerEndpointImpl.setKey((SelectionKey)object);
            }
            catch (IOException iOException) {
                DefaultListeningIOReactor.closeChannel(serverSocketChannel);
                throw new IOReactorException("Failure registering channel with the selector", iOException);
            }
            this.endpoints.add(listenerEndpointImpl);
            listenerEndpointImpl.completed(serverSocketChannel.socket().getLocalSocketAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        HashSet<ListenerEndpoint> hashSet = new HashSet<ListenerEndpoint>();
        Set<ListenerEndpointImpl> set = this.endpoints;
        synchronized (set) {
            Iterator<ListenerEndpointImpl> iterator = this.endpoints.iterator();
            while (iterator.hasNext()) {
                ListenerEndpoint listenerEndpoint = iterator.next();
                if (!listenerEndpoint.isClosed()) {
                    hashSet.add(listenerEndpoint);
                    continue;
                }
                iterator.remove();
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        if (this.paused) {
            return;
        }
        this.paused = true;
        Set<ListenerEndpointImpl> set = this.endpoints;
        synchronized (set) {
            for (ListenerEndpointImpl listenerEndpointImpl : this.endpoints) {
                if (listenerEndpointImpl.isClosed()) continue;
                listenerEndpointImpl.close();
                this.pausedEndpoints.add(listenerEndpointImpl.getAddress());
            }
            this.endpoints.clear();
        }
    }

    @Override
    public void resume() throws IOException {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        for (SocketAddress socketAddress : this.pausedEndpoints) {
            ListenerEndpointImpl listenerEndpointImpl = this.createEndpoint(socketAddress);
            this.requestQueue.add(listenerEndpointImpl);
        }
        this.pausedEndpoints.clear();
        this.selector.wakeup();
    }
}

