/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ExceptionEvent {
    private final Throwable ex;
    private final long time;

    public ExceptionEvent(Throwable throwable, Date date) {
        this.ex = throwable;
        this.time = date != null ? date.getTime() : 0L;
    }

    public ExceptionEvent(Exception exception) {
        this(exception, new Date());
    }

    public Throwable getCause() {
        return this.ex;
    }

    public Date getTimestamp() {
        return new Date(this.time);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new Date(this.time));
        stringBuilder.append(" ");
        stringBuilder.append(this.ex);
        return stringBuilder.toString();
    }
}

