/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.util.Args;

public final class IOReactorConfig
implements Cloneable {
    private static final int AVAIL_PROCS = Runtime.getRuntime().availableProcessors();
    public static final IOReactorConfig DEFAULT = new Builder().build();
    private long selectInterval;
    private long shutdownGracePeriod;
    private boolean interestOpQueued;
    private int ioThreadCount;
    private int soTimeout;
    private boolean soReuseAddress;
    private int soLinger;
    private boolean soKeepAlive;
    private boolean tcpNoDelay;
    private int connectTimeout;
    private int sndBufSize;
    private int rcvBufSize;
    private int backlogSize;

    @Deprecated
    public IOReactorConfig() {
        this.selectInterval = 1000L;
        this.shutdownGracePeriod = 500L;
        this.interestOpQueued = false;
        this.ioThreadCount = AVAIL_PROCS;
        this.soTimeout = 0;
        this.soReuseAddress = false;
        this.soLinger = -1;
        this.soKeepAlive = false;
        this.tcpNoDelay = true;
        this.connectTimeout = 0;
        this.sndBufSize = 0;
        this.rcvBufSize = 0;
        this.backlogSize = 0;
    }

    IOReactorConfig(long l, long l2, boolean bl, int n, int n2, boolean bl2, int n3, boolean bl3, boolean bl4, int n4, int n5, int n6, int n7) {
        this.selectInterval = l;
        this.shutdownGracePeriod = l2;
        this.interestOpQueued = bl;
        this.ioThreadCount = n;
        this.soTimeout = n2;
        this.soReuseAddress = bl2;
        this.soLinger = n3;
        this.soKeepAlive = bl3;
        this.tcpNoDelay = bl4;
        this.connectTimeout = n4;
        this.sndBufSize = n5;
        this.rcvBufSize = n6;
        this.backlogSize = n7;
    }

    public long getSelectInterval() {
        return this.selectInterval;
    }

    @Deprecated
    public void setSelectInterval(long l) {
        Args.positive((long)l, (String)"Select internal");
        this.selectInterval = l;
    }

    public long getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    @Deprecated
    public void setShutdownGracePeriod(long l) {
        Args.positive((long)l, (String)"Shutdown grace period");
        this.shutdownGracePeriod = l;
    }

    public boolean isInterestOpQueued() {
        return this.interestOpQueued;
    }

    @Deprecated
    public void setInterestOpQueued(boolean bl) {
        this.interestOpQueued = bl;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    @Deprecated
    public void setIoThreadCount(int n) {
        Args.positive((int)n, (String)"I/O thread count");
        this.ioThreadCount = n;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Deprecated
    public void setSoTimeout(int n) {
        this.soTimeout = n;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    @Deprecated
    public void setSoReuseAddress(boolean bl) {
        this.soReuseAddress = bl;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    @Deprecated
    public void setSoLinger(int n) {
        this.soLinger = n;
    }

    public boolean isSoKeepalive() {
        return this.soKeepAlive;
    }

    @Deprecated
    public void setSoKeepalive(boolean bl) {
        this.soKeepAlive = bl;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Deprecated
    public void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    @Deprecated
    public void setSndBufSize(int n) {
        this.sndBufSize = n;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    @Deprecated
    public void setRcvBufSize(int n) {
        this.rcvBufSize = n;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    protected IOReactorConfig clone() throws CloneNotSupportedException {
        return (IOReactorConfig)super.clone();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(IOReactorConfig iOReactorConfig) {
        Args.notNull((Object)iOReactorConfig, (String)"I/O reactor config");
        return new Builder().setSelectInterval(iOReactorConfig.getSelectInterval()).setShutdownGracePeriod(iOReactorConfig.getShutdownGracePeriod()).setInterestOpQueued(iOReactorConfig.isInterestOpQueued()).setIoThreadCount(iOReactorConfig.getIoThreadCount()).setSoTimeout(iOReactorConfig.getSoTimeout()).setSoReuseAddress(iOReactorConfig.isSoReuseAddress()).setSoLinger(iOReactorConfig.getSoLinger()).setSoKeepAlive(iOReactorConfig.isSoKeepalive()).setTcpNoDelay(iOReactorConfig.isTcpNoDelay()).setConnectTimeout(iOReactorConfig.getConnectTimeout()).setSndBufSize(iOReactorConfig.getSndBufSize()).setRcvBufSize(iOReactorConfig.getRcvBufSize()).setBacklogSize(iOReactorConfig.getBacklogSize());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[selectInterval=").append(this.selectInterval).append(", shutdownGracePeriod=").append(this.shutdownGracePeriod).append(", interestOpQueued=").append(this.interestOpQueued).append(", ioThreadCount=").append(this.ioThreadCount).append(", soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", connectTimeout=").append(this.connectTimeout).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ int access$000() {
        return AVAIL_PROCS;
    }

    public static class Builder {
        private long selectInterval = 1000L;
        private long shutdownGracePeriod = 500L;
        private boolean interestOpQueued = false;
        private int ioThreadCount = IOReactorConfig.access$000();
        private int soTimeout = 0;
        private boolean soReuseAddress = false;
        private int soLinger = -1;
        private boolean soKeepAlive = false;
        private boolean tcpNoDelay = true;
        private int connectTimeout = 0;
        private int sndBufSize = 0;
        private int rcvBufSize = 0;
        private int backlogSize = 0;

        Builder() {
        }

        public Builder setSelectInterval(long l) {
            this.selectInterval = l;
            return this;
        }

        public Builder setShutdownGracePeriod(long l) {
            this.shutdownGracePeriod = l;
            return this;
        }

        public Builder setInterestOpQueued(boolean bl) {
            this.interestOpQueued = bl;
            return this;
        }

        public Builder setIoThreadCount(int n) {
            this.ioThreadCount = n;
            return this;
        }

        public Builder setSoTimeout(int n) {
            this.soTimeout = n;
            return this;
        }

        public Builder setSoReuseAddress(boolean bl) {
            this.soReuseAddress = bl;
            return this;
        }

        public Builder setSoLinger(int n) {
            this.soLinger = n;
            return this;
        }

        public Builder setSoKeepAlive(boolean bl) {
            this.soKeepAlive = bl;
            return this;
        }

        public Builder setTcpNoDelay(boolean bl) {
            this.tcpNoDelay = bl;
            return this;
        }

        public Builder setConnectTimeout(int n) {
            this.connectTimeout = n;
            return this;
        }

        public Builder setSndBufSize(int n) {
            this.sndBufSize = n;
            return this;
        }

        public Builder setRcvBufSize(int n) {
            this.rcvBufSize = n;
            return this;
        }

        public Builder setBacklogSize(int n) {
            this.backlogSize = n;
            return this;
        }

        public IOReactorConfig build() {
            return new IOReactorConfig(this.selectInterval, this.shutdownGracePeriod, this.interestOpQueued, this.ioThreadCount, this.soTimeout, this.soReuseAddress, this.soLinger, this.soKeepAlive, this.tcpNoDelay, this.connectTimeout, this.sndBufSize, this.rcvBufSize, this.backlogSize);
        }
    }
}

