/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.impl.nio.reactor.ListenerEndpointClosedCallback;
import com.icbc.api.internal.apache.http.nio.reactor.ListenerEndpoint;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ListenerEndpointImpl
implements ListenerEndpoint {
    private volatile boolean completed;
    private volatile boolean closed;
    private volatile SelectionKey key;
    private volatile SocketAddress address;
    private volatile IOException exception;
    private final ListenerEndpointClosedCallback callback;

    public ListenerEndpointImpl(SocketAddress socketAddress, ListenerEndpointClosedCallback listenerEndpointClosedCallback) {
        Args.notNull((Object)socketAddress, (String)"Address");
        this.address = socketAddress;
        this.callback = listenerEndpointClosedCallback;
    }

    @Override
    public SocketAddress getAddress() {
        return this.address;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public IOException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor() throws InterruptedException {
        if (this.completed) {
            return;
        }
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(SocketAddress socketAddress) {
        Args.notNull((Object)socketAddress, (String)"Address");
        if (this.completed) {
            return;
        }
        this.completed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.address = socketAddress;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(IOException iOException) {
        if (iOException == null) {
            return;
        }
        if (this.completed) {
            return;
        }
        this.completed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.exception = iOException;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.closed = true;
        ListenerEndpointImpl listenerEndpointImpl = this;
        synchronized (listenerEndpointImpl) {
            this.notifyAll();
        }
    }

    protected void setKey(SelectionKey selectionKey) {
        this.key = selectionKey;
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.key != null && !this.key.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object;
        if (this.closed) {
            return;
        }
        this.completed = true;
        this.closed = true;
        if (this.key != null) {
            this.key.cancel();
            object = this.key.channel();
            try {
                object.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.callback != null) {
            this.callback.endpointClosed(this);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }
}

