/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.reactor;

import com.icbc.api.internal.apache.http.MessageConstraintException;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import com.icbc.api.internal.apache.http.util.CharsetUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class SessionInputBufferImpl
extends ExpandableBuffer
implements SessionInputBuffer {
    private final CharsetDecoder chardecoder;
    private final MessageConstraints constraints;
    private final int lineBuffersize;
    private CharBuffer charbuffer;

    public SessionInputBufferImpl(int n, int n2, MessageConstraints messageConstraints, CharsetDecoder charsetDecoder, ByteBufferAllocator byteBufferAllocator) {
        super(n, (ByteBufferAllocator)(byteBufferAllocator != null ? byteBufferAllocator : HeapByteBufferAllocator.INSTANCE));
        this.lineBuffersize = Args.positive((int)n2, (String)"Line buffer size");
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.chardecoder = charsetDecoder;
    }

    public SessionInputBufferImpl(int n, int n2, CharsetDecoder charsetDecoder, ByteBufferAllocator byteBufferAllocator) {
        this(n, n2, null, charsetDecoder, byteBufferAllocator);
    }

    @Deprecated
    public SessionInputBufferImpl(int n, int n2, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(n, byteBufferAllocator);
        this.lineBuffersize = Args.positive((int)n2, (String)"Line buffer size");
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        Charset charset = CharsetUtils.lookup((String)string);
        if (charset != null) {
            this.chardecoder = charset.newDecoder();
            CodingErrorAction codingErrorAction = (CodingErrorAction)httpParams.getParameter("http.malformed.input.action");
            this.chardecoder.onMalformedInput(codingErrorAction != null ? codingErrorAction : CodingErrorAction.REPORT);
            CodingErrorAction codingErrorAction2 = (CodingErrorAction)httpParams.getParameter("http.unmappable.input.action");
            this.chardecoder.onUnmappableCharacter(codingErrorAction2 != null ? codingErrorAction2 : CodingErrorAction.REPORT);
        } else {
            this.chardecoder = null;
        }
        this.constraints = MessageConstraints.DEFAULT;
    }

    @Deprecated
    public SessionInputBufferImpl(int n, int n2, HttpParams httpParams) {
        this(n, n2, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    public SessionInputBufferImpl(int n, int n2, Charset charset) {
        this(n, n2, null, charset != null ? charset.newDecoder() : null, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    public SessionInputBufferImpl(int n, int n2, MessageConstraints messageConstraints, Charset charset) {
        this(n, n2, messageConstraints, charset != null ? charset.newDecoder() : null, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    public SessionInputBufferImpl(int n, int n2) {
        this(n, n2, null, null, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    public SessionInputBufferImpl(int n) {
        this(n, 256, null, null, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public int fill(ReadableByteChannel readableByteChannel) throws IOException {
        Args.notNull((Object)readableByteChannel, (String)"Channel");
        this.setInputMode();
        if (!this.buffer.hasRemaining()) {
            this.expand();
        }
        return readableByteChannel.read(this.buffer);
    }

    @Override
    public int read() {
        this.setOutputMode();
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            return 0;
        }
        this.setOutputMode();
        int n2 = Math.min(byteBuffer.remaining(), n);
        int n3 = Math.min(this.buffer.remaining(), n2);
        if (this.buffer.remaining() > n3) {
            int n4 = this.buffer.limit();
            int n5 = this.buffer.position() + n3;
            this.buffer.limit(n5);
            byteBuffer.put(this.buffer);
            this.buffer.limit(n4);
            return n2;
        }
        byteBuffer.put(this.buffer);
        return n3;
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return 0;
        }
        return this.read(byteBuffer, byteBuffer.remaining());
    }

    @Override
    public int read(WritableByteChannel writableByteChannel, int n) throws IOException {
        int n2;
        if (writableByteChannel == null) {
            return 0;
        }
        this.setOutputMode();
        if (this.buffer.remaining() > n) {
            int n3 = this.buffer.limit();
            int n4 = n3 - (this.buffer.remaining() - n);
            this.buffer.limit(n4);
            n2 = writableByteChannel.write(this.buffer);
            this.buffer.limit(n3);
        } else {
            n2 = writableByteChannel.write(this.buffer);
        }
        return n2;
    }

    @Override
    public int read(WritableByteChannel writableByteChannel) throws IOException {
        if (writableByteChannel == null) {
            return 0;
        }
        this.setOutputMode();
        return writableByteChannel.write(this.buffer);
    }

    @Override
    public boolean readLine(CharArrayBuffer charArrayBuffer, boolean bl) throws CharacterCodingException {
        Object object;
        int n;
        int n2;
        this.setOutputMode();
        int n3 = -1;
        for (n2 = this.buffer.position(); n2 < this.buffer.limit(); ++n2) {
            n = this.buffer.get(n2);
            if (n != 10) continue;
            n3 = n2 + 1;
            break;
        }
        if ((n2 = this.constraints.getMaxLineLength()) > 0 && (n = (n3 > 0 ? n3 : this.buffer.limit()) - this.buffer.position()) >= n2) {
            throw new MessageConstraintException("Maximum line length limit exceeded");
        }
        if (n3 == -1) {
            if (bl && this.buffer.hasRemaining()) {
                n3 = this.buffer.limit();
            } else {
                return false;
            }
        }
        n = this.buffer.limit();
        this.buffer.limit(n3);
        int n4 = this.buffer.limit() - this.buffer.position();
        charArrayBuffer.ensureCapacity(n4);
        if (this.chardecoder == null) {
            if (this.buffer.hasArray()) {
                object = this.buffer.array();
                int n5 = this.buffer.position();
                int n6 = this.buffer.remaining();
                charArrayBuffer.append((byte[])object, n5, n6);
                this.buffer.position(n5 + n6);
            } else {
                while (this.buffer.hasRemaining()) {
                    charArrayBuffer.append((char)(this.buffer.get() & 0xFF));
                }
            }
        } else {
            if (this.charbuffer == null) {
                this.charbuffer = CharBuffer.allocate(this.lineBuffersize);
            }
            this.chardecoder.reset();
            do {
                if (((CoderResult)(object = (Object)this.chardecoder.decode(this.buffer, this.charbuffer, true))).isError()) {
                    ((CoderResult)object).throwException();
                }
                if (!((CoderResult)object).isOverflow()) continue;
                this.charbuffer.flip();
                charArrayBuffer.append(this.charbuffer.array(), this.charbuffer.position(), this.charbuffer.remaining());
                this.charbuffer.clear();
            } while (!((CoderResult)object).isUnderflow());
            this.chardecoder.flush(this.charbuffer);
            this.charbuffer.flip();
            if (this.charbuffer.hasRemaining()) {
                charArrayBuffer.append(this.charbuffer.array(), this.charbuffer.position(), this.charbuffer.remaining());
            }
        }
        this.buffer.limit(n);
        int n7 = charArrayBuffer.length();
        if (n7 > 0) {
            if (charArrayBuffer.charAt(n7 - 1) == '\n') {
                charArrayBuffer.setLength(--n7);
            }
            if (n7 > 0 && charArrayBuffer.charAt(n7 - 1) == '\r') {
                charArrayBuffer.setLength(--n7);
            }
        }
        return true;
    }

    @Override
    public String readLine(boolean bl) throws CharacterCodingException {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        boolean bl2 = this.readLine(charArrayBuffer, bl);
        if (bl2) {
            return charArrayBuffer.toString();
        }
        return null;
    }
}

