/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.message;

import com.icbc.api.internal.apache.http.FormattedHeader;
import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.message.BasicHeaderValueParser;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.io.Serializable;

public class BufferedHeader
implements FormattedHeader,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2768352615787625448L;
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;

    public BufferedHeader(CharArrayBuffer charArrayBuffer) throws ParseException {
        Args.notNull((Object)charArrayBuffer, (String)"Char array buffer");
        int n = charArrayBuffer.indexOf(58);
        if (n == -1) {
            throw new ParseException("Invalid header: " + charArrayBuffer.toString());
        }
        String string = charArrayBuffer.substringTrimmed(0, n);
        if (string.length() == 0) {
            throw new ParseException("Invalid header: " + charArrayBuffer.toString());
        }
        this.buffer = charArrayBuffer;
        this.name = string;
        this.valuePos = n + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.buffer.substringTrimmed(this.valuePos, this.buffer.length());
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        ParserCursor parserCursor = new ParserCursor(0, this.buffer.length());
        parserCursor.updatePos(this.valuePos);
        return BasicHeaderValueParser.INSTANCE.parseElements(this.buffer, parserCursor);
    }

    @Override
    public int getValuePos() {
        return this.valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

