/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.client.methods;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HTTP;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class AsyncCharConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final ByteBuffer bbuf;
    private final CharBuffer cbuf;
    private CharsetDecoder chardecoder;

    public AsyncCharConsumer(int n) {
        this.bbuf = ByteBuffer.allocate(n);
        this.cbuf = CharBuffer.allocate(n);
    }

    public AsyncCharConsumer() {
        this(8192);
    }

    protected abstract void onCharReceived(CharBuffer var1, IOControl var2) throws IOException;

    protected CharsetDecoder createDecoder(ContentType contentType) {
        Charset charset;
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        return charset.newDecoder();
    }

    @Override
    protected final void onEntityEnclosed(HttpEntity httpEntity, ContentType contentType) throws IOException {
        this.chardecoder = this.createDecoder(contentType != null ? contentType : ContentType.DEFAULT_TEXT);
    }

    @Override
    protected final void onContentReceived(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        Asserts.notNull((Object)this.bbuf, (String)"Byte buffer");
        int n = contentDecoder.read(this.bbuf);
        if (n <= 0) {
            return;
        }
        this.bbuf.flip();
        boolean bl = contentDecoder.isCompleted();
        CoderResult coderResult = this.chardecoder.decode(this.bbuf, this.cbuf, bl);
        this.handleDecodingResult(coderResult, iOControl);
        this.bbuf.compact();
        if (bl) {
            coderResult = this.chardecoder.flush(this.cbuf);
            this.handleDecodingResult(coderResult, iOControl);
        }
    }

    private void handleDecodingResult(CoderResult coderResult, IOControl iOControl) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        if (this.cbuf.hasRemaining()) {
            this.onCharReceived(this.cbuf, iOControl);
        }
        this.cbuf.clear();
    }

    @Override
    protected void releaseResources() {
    }
}

