/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.client.methods;

import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.methods.HttpDelete;
import com.icbc.api.internal.apache.http.client.methods.HttpGet;
import com.icbc.api.internal.apache.http.client.methods.HttpOptions;
import com.icbc.api.internal.apache.http.client.methods.HttpPost;
import com.icbc.api.internal.apache.http.client.methods.HttpPut;
import com.icbc.api.internal.apache.http.client.methods.HttpTrace;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.client.methods.ZeroCopyConsumer;
import com.icbc.api.internal.apache.http.nio.client.methods.ZeroCopyPost;
import com.icbc.api.internal.apache.http.nio.client.methods.ZeroCopyPut;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.NByteArrayEntity;
import com.icbc.api.internal.apache.http.nio.entity.NStringEntity;
import com.icbc.api.internal.apache.http.nio.protocol.BasicAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public final class HttpAsyncMethods {
    public static HttpAsyncRequestProducer create(HttpHost httpHost, HttpRequest httpRequest) {
        Args.notNull((Object)httpHost, (String)"HTTP host");
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        return new RequestProducerImpl(httpHost, httpRequest);
    }

    public static HttpAsyncRequestProducer create(HttpUriRequest httpUriRequest) {
        Args.notNull((Object)httpUriRequest, (String)"HTTP request");
        HttpHost httpHost = URIUtils.extractHost(httpUriRequest.getURI());
        return new RequestProducerImpl(httpHost, httpUriRequest);
    }

    public static HttpAsyncRequestProducer createGet(URI uRI) {
        return HttpAsyncMethods.create(new HttpGet(uRI));
    }

    public static HttpAsyncRequestProducer createGet(String string) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(string)));
    }

    public static HttpAsyncRequestProducer createHead(URI uRI) {
        return HttpAsyncMethods.create(new HttpGet(uRI));
    }

    public static HttpAsyncRequestProducer createHead(String string) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(string)));
    }

    public static HttpAsyncRequestProducer createDelete(URI uRI) {
        return HttpAsyncMethods.create(new HttpDelete(uRI));
    }

    public static HttpAsyncRequestProducer createDelete(String string) {
        return HttpAsyncMethods.create(new HttpDelete(URI.create(string)));
    }

    public static HttpAsyncRequestProducer createOptions(URI uRI) {
        return HttpAsyncMethods.create(new HttpOptions(uRI));
    }

    public static HttpAsyncRequestProducer createOptions(String string) {
        return HttpAsyncMethods.create(new HttpOptions(URI.create(string)));
    }

    public static HttpAsyncRequestProducer createTrace(URI uRI) {
        return HttpAsyncMethods.create(new HttpTrace(uRI));
    }

    public static HttpAsyncRequestProducer createTrace(String string) {
        return HttpAsyncMethods.create(new HttpTrace(URI.create(string)));
    }

    public static HttpAsyncRequestProducer createPost(URI uRI, String string, ContentType contentType) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(uRI);
        NStringEntity nStringEntity = new NStringEntity(string, contentType);
        httpPost.setEntity(nStringEntity);
        HttpHost httpHost = URIUtils.extractHost(uRI);
        return new RequestProducerImpl(httpHost, httpPost, nStringEntity);
    }

    public static HttpAsyncRequestProducer createPost(String string, String string2, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPost(URI.create(string), string2, contentType);
    }

    public static HttpAsyncRequestProducer createPost(URI uRI, byte[] byArray, ContentType contentType) {
        HttpPost httpPost = new HttpPost(uRI);
        NByteArrayEntity nByteArrayEntity = new NByteArrayEntity(byArray, contentType);
        HttpHost httpHost = URIUtils.extractHost(uRI);
        return new RequestProducerImpl(httpHost, httpPost, nByteArrayEntity);
    }

    public static HttpAsyncRequestProducer createPost(String string, byte[] byArray, ContentType contentType) {
        return HttpAsyncMethods.createPost(URI.create(string), byArray, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI uRI, String string, ContentType contentType) throws UnsupportedEncodingException {
        HttpPut httpPut = new HttpPut(uRI);
        NStringEntity nStringEntity = new NStringEntity(string, contentType);
        httpPut.setEntity(nStringEntity);
        HttpHost httpHost = URIUtils.extractHost(uRI);
        return new RequestProducerImpl(httpHost, httpPut, nStringEntity);
    }

    public static HttpAsyncRequestProducer createPut(String string, String string2, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPut(URI.create(string), string2, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI uRI, byte[] byArray, ContentType contentType) {
        HttpPut httpPut = new HttpPut(uRI);
        NByteArrayEntity nByteArrayEntity = new NByteArrayEntity(byArray, contentType);
        HttpHost httpHost = URIUtils.extractHost(uRI);
        return new RequestProducerImpl(httpHost, httpPut, nByteArrayEntity);
    }

    public static HttpAsyncRequestProducer createPut(String string, byte[] byArray, ContentType contentType) {
        return HttpAsyncMethods.createPut(URI.create(string), byArray, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(URI uRI, File file, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(uRI, file, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(String string, File file, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(URI.create(string), file, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(URI uRI, File file, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(uRI, file, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(String string, File file, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(URI.create(string), file, contentType);
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createConsumer() {
        return new BasicAsyncResponseConsumer();
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createZeroCopyConsumer(File file) throws FileNotFoundException {
        return new ZeroCopyConsumer<HttpResponse>(file){

            @Override
            protected HttpResponse process(HttpResponse httpResponse, File file, ContentType contentType) {
                return httpResponse;
            }
        };
    }

    static class RequestProducerImpl
    extends BasicAsyncRequestProducer {
        protected RequestProducerImpl(HttpHost httpHost, HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpAsyncContentProducer httpAsyncContentProducer) {
            super(httpHost, httpEntityEnclosingRequest, httpAsyncContentProducer);
        }

        public RequestProducerImpl(HttpHost httpHost, HttpRequest httpRequest) {
            super(httpHost, httpRequest);
        }
    }
}

