/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.client.methods;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.entity.FileEntity;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentDecoderChannel;
import com.icbc.api.internal.apache.http.nio.FileContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public abstract class ZeroCopyConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final File file;
    private final RandomAccessFile accessfile;
    private HttpResponse response;
    private ContentType contentType;
    private Header contentEncoding;
    private FileChannel fileChannel;
    private long idx = -1L;

    public ZeroCopyConsumer(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File may nor be null");
        }
        this.file = file;
        this.accessfile = new RandomAccessFile(this.file, "rw");
    }

    @Override
    protected void onResponseReceived(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity httpEntity, ContentType contentType) throws IOException {
        this.contentType = contentType;
        this.contentEncoding = httpEntity.getContentEncoding();
        this.fileChannel = this.accessfile.getChannel();
        this.idx = 0L;
    }

    @Override
    protected void onContentReceived(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        Asserts.notNull((Object)this.fileChannel, (String)"File channel");
        long l = contentDecoder instanceof FileContentDecoder ? ((FileContentDecoder)contentDecoder).transfer(this.fileChannel, this.idx, Integer.MAX_VALUE) : this.fileChannel.transferFrom(new ContentDecoderChannel(contentDecoder), this.idx, Integer.MAX_VALUE);
        if (l > 0L) {
            this.idx += l;
        }
        if (contentDecoder.isCompleted()) {
            this.fileChannel.close();
        }
    }

    protected abstract T process(HttpResponse var1, File var2, ContentType var3) throws Exception;

    @Override
    protected T buildResult(HttpContext httpContext) throws Exception {
        FileEntity fileEntity = new FileEntity(this.file, this.contentType);
        fileEntity.setContentEncoding(this.contentEncoding);
        this.response.setEntity(fileEntity);
        return this.process(this.response, this.file, this.contentType);
    }

    @Override
    protected void releaseResources() {
        try {
            this.accessfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

