/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class EntityAsyncContentProducer
implements HttpAsyncContentProducer {
    private final HttpEntity entity;
    private final ByteBuffer buffer;
    private ReadableByteChannel channel;

    public EntityAsyncContentProducer(HttpEntity httpEntity) {
        Args.notNull((Object)httpEntity, (String)"HTTP entity");
        this.entity = httpEntity;
        this.buffer = ByteBuffer.allocate(4096);
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.channel == null) {
            this.channel = Channels.newChannel(this.entity.getContent());
        }
        int n = this.channel.read(this.buffer);
        this.buffer.flip();
        contentEncoder.write(this.buffer);
        boolean bl = this.buffer.hasRemaining();
        this.buffer.compact();
        if (n == -1 && !bl) {
            contentEncoder.complete();
            this.close();
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    @Override
    public void close() throws IOException {
        ReadableByteChannel readableByteChannel = this.channel;
        this.channel = null;
        if (readableByteChannel != null) {
            readableByteChannel.close();
        }
        if (this.entity.isStreaming()) {
            InputStream inputStream = this.entity.getContent();
            inputStream.close();
        }
    }

    public String toString() {
        return this.entity.toString();
    }
}

