/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.entity.AbstractHttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoderChannel;
import com.icbc.api.internal.apache.http.nio.FileContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.ProducingNHttpEntity;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class NFileEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer,
ProducingNHttpEntity {
    private final File file;
    private RandomAccessFile accessfile;
    private FileChannel fileChannel;
    private long idx = -1L;
    private boolean useFileChannels;

    public NFileEntity(File file, ContentType contentType, boolean bl) {
        Args.notNull((Object)file, (String)"File");
        this.file = file;
        this.useFileChannels = bl;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NFileEntity(File file) {
        Args.notNull((Object)file, (String)"File");
        this.file = file;
    }

    public NFileEntity(File file, ContentType contentType) {
        this(file, contentType, true);
    }

    @Deprecated
    public NFileEntity(File file, String string, boolean bl) {
        Args.notNull((Object)file, (String)"File");
        this.file = file;
        this.useFileChannels = bl;
        this.setContentType(string);
    }

    @Deprecated
    public NFileEntity(File file, String string) {
        this(file, string, true);
    }

    @Override
    public void close() throws IOException {
        if (this.accessfile != null) {
            this.accessfile.close();
        }
        this.accessfile = null;
        this.fileChannel = null;
    }

    @Override
    @Deprecated
    public void finish() throws IOException {
        this.close();
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        long l;
        if (this.accessfile == null) {
            this.accessfile = new RandomAccessFile(this.file, "r");
        }
        if (this.fileChannel == null) {
            this.fileChannel = this.accessfile.getChannel();
            this.idx = 0L;
        }
        if ((l = this.useFileChannels && contentEncoder instanceof FileContentEncoder ? ((FileContentEncoder)contentEncoder).transfer(this.fileChannel, this.idx, Long.MAX_VALUE) : this.fileChannel.transferTo(this.idx, Long.MAX_VALUE, new ContentEncoderChannel(contentEncoder))) > 0L) {
            this.idx += l;
        }
        if (this.idx >= this.fileChannel.size()) {
            contentEncoder.complete();
            this.close();
        }
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull((Object)outputStream, (String)"Output stream");
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
    }
}

