/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.entity;

import com.icbc.api.internal.apache.http.entity.AbstractHttpEntity;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.ProducingNHttpEntity;
import com.icbc.api.internal.apache.http.protocol.HTTP;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class NStringEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer,
ProducingNHttpEntity {
    private final byte[] b;
    private final ByteBuffer buf;
    @Deprecated
    protected final byte[] content;
    @Deprecated
    protected final ByteBuffer buffer;

    public NStringEntity(String string, ContentType contentType) {
        Charset charset;
        Args.notNull((Object)string, (String)"Source string");
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (charset == null) {
            charset = HTTP.DEF_CONTENT_CHARSET;
        }
        this.b = string.getBytes(charset);
        this.buf = ByteBuffer.wrap(this.b);
        this.content = this.b;
        this.buffer = this.buf;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NStringEntity(String string, String string2) throws UnsupportedEncodingException {
        this(string, ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), string2));
    }

    public NStringEntity(String string, Charset charset) {
        this(string, ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), charset));
    }

    public NStringEntity(String string) throws UnsupportedEncodingException {
        this(string, ContentType.DEFAULT_TEXT);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.b.length;
    }

    @Override
    public void close() {
        this.buf.rewind();
    }

    @Override
    @Deprecated
    public void finish() {
        this.close();
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        contentEncoder.write(this.buf);
        if (!this.buf.hasRemaining()) {
            contentEncoder.complete();
        }
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.b);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull((Object)outputStream, (String)"Output stream");
        outputStream.write(this.b);
        outputStream.flush();
    }
}

