/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.pool;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.nio.pool.LeaseRequest;
import com.icbc.api.internal.apache.http.nio.pool.NIOConnFactory;
import com.icbc.api.internal.apache.http.nio.pool.RouteSpecificPool;
import com.icbc.api.internal.apache.http.nio.pool.SocketAddressResolver;
import com.icbc.api.internal.apache.http.nio.reactor.ConnectingIOReactor;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequest;
import com.icbc.api.internal.apache.http.nio.reactor.SessionRequestCallback;
import com.icbc.api.internal.apache.http.pool.ConnPool;
import com.icbc.api.internal.apache.http.pool.ConnPoolControl;
import com.icbc.api.internal.apache.http.pool.PoolEntry;
import com.icbc.api.internal.apache.http.pool.PoolEntryCallback;
import com.icbc.api.internal.apache.http.pool.PoolStats;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractNIOConnPool<T, C, E extends PoolEntry<T, C>>
implements ConnPool<T, E>,
ConnPoolControl<T> {
    private final ConnectingIOReactor ioreactor;
    private final NIOConnFactory<T, C> connFactory;
    private final SocketAddressResolver<T> addressResolver;
    private final SessionRequestCallback sessionRequestCallback;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final LinkedList<LeaseRequest<T, C, E>> leasingRequests;
    private final Set<SessionRequest> pending;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final ConcurrentLinkedQueue<LeaseRequest<T, C, E>> completedRequests;
    private final Map<T, Integer> maxPerRoute;
    private final Lock lock;
    private final AtomicBoolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;

    @Deprecated
    public AbstractNIOConnPool(ConnectingIOReactor connectingIOReactor, NIOConnFactory<T, C> nIOConnFactory, int n, int n2) {
        Args.notNull((Object)connectingIOReactor, (String)"I/O reactor");
        Args.notNull(nIOConnFactory, (String)"Connection factory");
        Args.positive((int)n, (String)"Max per route value");
        Args.positive((int)n2, (String)"Max total value");
        this.ioreactor = connectingIOReactor;
        this.connFactory = nIOConnFactory;
        this.addressResolver = new SocketAddressResolver<T>(){

            @Override
            public SocketAddress resolveLocalAddress(T t) throws IOException {
                return AbstractNIOConnPool.this.resolveLocalAddress(t);
            }

            @Override
            public SocketAddress resolveRemoteAddress(T t) throws IOException {
                return AbstractNIOConnPool.this.resolveRemoteAddress(t);
            }
        };
        this.sessionRequestCallback = new InternalSessionRequestCallback();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leasingRequests = new LinkedList();
        this.pending = new HashSet<SessionRequest>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.completedRequests = new ConcurrentLinkedQueue();
        this.lock = new ReentrantLock();
        this.isShutDown = new AtomicBoolean(false);
        this.defaultMaxPerRoute = n;
        this.maxTotal = n2;
    }

    public AbstractNIOConnPool(ConnectingIOReactor connectingIOReactor, NIOConnFactory<T, C> nIOConnFactory, SocketAddressResolver<T> socketAddressResolver, int n, int n2) {
        Args.notNull((Object)connectingIOReactor, (String)"I/O reactor");
        Args.notNull(nIOConnFactory, (String)"Connection factory");
        Args.notNull(socketAddressResolver, (String)"Address resolver");
        Args.positive((int)n, (String)"Max per route value");
        Args.positive((int)n2, (String)"Max total value");
        this.ioreactor = connectingIOReactor;
        this.connFactory = nIOConnFactory;
        this.addressResolver = socketAddressResolver;
        this.sessionRequestCallback = new InternalSessionRequestCallback();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leasingRequests = new LinkedList();
        this.pending = new HashSet<SessionRequest>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.completedRequests = new ConcurrentLinkedQueue();
        this.maxPerRoute = new HashMap<T, Integer>();
        this.lock = new ReentrantLock();
        this.isShutDown = new AtomicBoolean(false);
        this.defaultMaxPerRoute = n;
        this.maxTotal = n2;
    }

    @Deprecated
    protected SocketAddress resolveRemoteAddress(T t) {
        return null;
    }

    @Deprecated
    protected SocketAddress resolveLocalAddress(T t) {
        return null;
    }

    protected abstract E createEntry(T var1, C var2);

    protected void onLease(E e) {
    }

    protected void onRelease(E e) {
    }

    protected void onReuse(E e) {
    }

    public boolean isShutdown() {
        return this.isShutDown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(long l) throws IOException {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.fireCallbacks();
            this.lock.lock();
            try {
                for (SessionRequest object : this.pending) {
                    object.cancel();
                }
                for (PoolEntry poolEntry : this.available) {
                    poolEntry.close();
                }
                for (PoolEntry poolEntry : this.leased) {
                    poolEntry.close();
                }
                for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                    routeSpecificPool.shutdown();
                }
                this.routeToPool.clear();
                this.leased.clear();
                this.pending.clear();
                this.available.clear();
                this.leasingRequests.clear();
                this.ioreactor.shutdown(l);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private RouteSpecificPool<T, C, E> getPool(T t) {
        RouteSpecificPool routeSpecificPool = this.routeToPool.get(t);
        if (routeSpecificPool == null) {
            routeSpecificPool = new RouteSpecificPool<T, C, E>(t){

                @Override
                protected E createEntry(T t, C c2) {
                    return AbstractNIOConnPool.this.createEntry(t, c2);
                }
            };
            this.routeToPool.put(t, routeSpecificPool);
        }
        return routeSpecificPool;
    }

    public Future<E> lease(T t, Object object, long l, TimeUnit timeUnit, FutureCallback<E> futureCallback) {
        return this.lease(t, object, l, l, timeUnit, futureCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<E> lease(T t, Object object, long l, long l2, TimeUnit timeUnit, FutureCallback<E> futureCallback) {
        Args.notNull(t, (String)"Route");
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        Asserts.check((!this.isShutDown.get() ? 1 : 0) != 0, (String)"Connection pool shut down");
        BasicFuture<E> basicFuture = new BasicFuture<E>(futureCallback);
        this.lock.lock();
        try {
            long l3 = l > 0L ? timeUnit.toMillis(l) : 0L;
            LeaseRequest leaseRequest = new LeaseRequest(t, object, l3, l2, basicFuture);
            boolean bl = this.processPendingRequest(leaseRequest);
            if (!leaseRequest.isDone() && !bl) {
                this.leasingRequests.add(leaseRequest);
            }
            if (leaseRequest.isDone()) {
                this.completedRequests.add(leaseRequest);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
        return basicFuture;
    }

    @Override
    public Future<E> lease(T t, Object object, FutureCallback<E> futureCallback) {
        return this.lease(t, object, -1L, TimeUnit.MICROSECONDS, futureCallback);
    }

    public Future<E> lease(T t, Object object) {
        return this.lease(t, object, -1L, TimeUnit.MICROSECONDS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(E e, boolean bl) {
        if (e == null) {
            return;
        }
        if (this.isShutDown.get()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.leased.remove(e)) {
                RouteSpecificPool routeSpecificPool = this.getPool(((PoolEntry)e).getRoute());
                routeSpecificPool.free(e, bl);
                if (bl) {
                    this.available.addFirst(e);
                    this.onRelease(e);
                } else {
                    ((PoolEntry)e).close();
                }
                this.processNextPendingRequest();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    private void processPendingRequests() {
        ListIterator listIterator = this.leasingRequests.listIterator();
        while (listIterator.hasNext()) {
            LeaseRequest leaseRequest = (LeaseRequest)listIterator.next();
            boolean bl = this.processPendingRequest(leaseRequest);
            if (leaseRequest.isDone() || bl) {
                listIterator.remove();
            }
            if (!leaseRequest.isDone()) continue;
            this.completedRequests.add(leaseRequest);
        }
    }

    private void processNextPendingRequest() {
        ListIterator listIterator = this.leasingRequests.listIterator();
        while (listIterator.hasNext()) {
            LeaseRequest leaseRequest = (LeaseRequest)listIterator.next();
            boolean bl = this.processPendingRequest(leaseRequest);
            if (leaseRequest.isDone() || bl) {
                listIterator.remove();
            }
            if (leaseRequest.isDone()) {
                this.completedRequests.add(leaseRequest);
            }
            if (!bl) continue;
            return;
        }
    }

    private boolean processPendingRequest(LeaseRequest<T, C, E> leaseRequest) {
        int n;
        E e;
        T t = leaseRequest.getRoute();
        Object object = leaseRequest.getState();
        long l = leaseRequest.getDeadline();
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            leaseRequest.failed(new TimeoutException());
            return false;
        }
        RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t);
        while ((e = routeSpecificPool.getFree(object)) != null && (((PoolEntry)e).isClosed() || ((PoolEntry)e).isExpired(System.currentTimeMillis()))) {
            ((PoolEntry)e).close();
            this.available.remove(e);
            routeSpecificPool.free(e, false);
        }
        if (e != null) {
            this.available.remove(e);
            this.leased.add(e);
            leaseRequest.completed(e);
            this.onReuse(e);
            this.onLease(e);
            return true;
        }
        int n2 = this.getMax(t);
        int n3 = Math.max(0, routeSpecificPool.getAllocatedCount() + 1 - n2);
        if (n3 > 0) {
            E e2;
            for (n = 0; n < n3 && (e2 = routeSpecificPool.getLastUsed()) != null; ++n) {
                ((PoolEntry)e2).close();
                this.available.remove(e2);
                routeSpecificPool.remove(e2);
            }
        }
        if (routeSpecificPool.getAllocatedCount() < n2) {
            Object object2;
            Object object3;
            n = this.pending.size() + this.leased.size();
            int n4 = Math.max(this.maxTotal - n, 0);
            if (n4 == 0) {
                return false;
            }
            int n5 = this.available.size();
            if (n5 > n4 - 1 && !this.available.isEmpty()) {
                object3 = (PoolEntry)this.available.removeLast();
                ((PoolEntry)object3).close();
                object2 = this.getPool(((PoolEntry)object3).getRoute());
                ((RouteSpecificPool)object2).remove(object3);
            }
            try {
                object2 = this.addressResolver.resolveRemoteAddress(t);
                object3 = this.addressResolver.resolveLocalAddress(t);
            }
            catch (IOException iOException) {
                leaseRequest.failed(iOException);
                return false;
            }
            SessionRequest sessionRequest = this.ioreactor.connect((SocketAddress)object2, (SocketAddress)object3, t, this.sessionRequestCallback);
            int n6 = leaseRequest.getConnectTimeout() < Integer.MAX_VALUE ? (int)leaseRequest.getConnectTimeout() : Integer.MAX_VALUE;
            sessionRequest.setConnectTimeout(n6);
            this.pending.add(sessionRequest);
            routeSpecificPool.addPending(sessionRequest, leaseRequest.getFuture());
            return true;
        }
        return false;
    }

    private void fireCallbacks() {
        LeaseRequest<T, C, E> leaseRequest;
        while ((leaseRequest = this.completedRequests.poll()) != null) {
            BasicFuture<E> basicFuture = leaseRequest.getFuture();
            Exception exception = leaseRequest.getException();
            E e = leaseRequest.getResult();
            if (exception != null) {
                basicFuture.failed(exception);
                continue;
            }
            if (e != null) {
                basicFuture.completed(e);
                continue;
            }
            basicFuture.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePendingRequests() {
        this.lock.lock();
        try {
            long l = System.currentTimeMillis();
            ListIterator listIterator = this.leasingRequests.listIterator();
            while (listIterator.hasNext()) {
                LeaseRequest leaseRequest = (LeaseRequest)listIterator.next();
                long l2 = leaseRequest.getDeadline();
                if (l <= l2) continue;
                listIterator.remove();
                leaseRequest.failed(new TimeoutException());
                this.completedRequests.add(leaseRequest);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCompleted(SessionRequest sessionRequest) {
        if (this.isShutDown.get()) {
            return;
        }
        Object object = sessionRequest.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(sessionRequest);
            RouteSpecificPool<Object, C, E> routeSpecificPool = this.getPool(object);
            IOSession iOSession = sessionRequest.getSession();
            try {
                C c2 = this.connFactory.create(object, iOSession);
                E e = routeSpecificPool.createEntry(sessionRequest, c2);
                this.leased.add(e);
                routeSpecificPool.completed(sessionRequest, e);
                this.onLease(e);
            }
            catch (IOException iOException) {
                routeSpecificPool.failed(sessionRequest, iOException);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCancelled(SessionRequest sessionRequest) {
        if (this.isShutDown.get()) {
            return;
        }
        Object object = sessionRequest.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(sessionRequest);
            RouteSpecificPool<Object, C, E> routeSpecificPool = this.getPool(object);
            routeSpecificPool.cancelled(sessionRequest);
            if (this.ioreactor.getStatus().compareTo((Enum)IOReactorStatus.ACTIVE) <= 0) {
                this.processNextPendingRequest();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailed(SessionRequest sessionRequest) {
        if (this.isShutDown.get()) {
            return;
        }
        Object object = sessionRequest.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(sessionRequest);
            RouteSpecificPool<Object, C, E> routeSpecificPool = this.getPool(object);
            routeSpecificPool.failed(sessionRequest, sessionRequest.getException());
            this.processNextPendingRequest();
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestTimeout(SessionRequest sessionRequest) {
        if (this.isShutDown.get()) {
            return;
        }
        Object object = sessionRequest.getAttachment();
        this.lock.lock();
        try {
            this.pending.remove(sessionRequest);
            RouteSpecificPool<Object, C, E> routeSpecificPool = this.getPool(object);
            routeSpecificPool.timeout(sessionRequest);
            this.processNextPendingRequest();
        }
        finally {
            this.lock.unlock();
        }
        this.fireCallbacks();
    }

    private int getMax(T t) {
        Integer n = this.maxPerRoute.get(t);
        if (n != null) {
            return n;
        }
        return this.defaultMaxPerRoute;
    }

    @Override
    public void setMaxTotal(int n) {
        Args.positive((int)n, (String)"Max value");
        this.lock.lock();
        try {
            this.maxTotal = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxTotal() {
        this.lock.lock();
        try {
            int n = this.maxTotal;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setDefaultMaxPerRoute(int n) {
        Args.positive((int)n, (String)"Max value");
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getDefaultMaxPerRoute() {
        this.lock.lock();
        try {
            int n = this.defaultMaxPerRoute;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setMaxPerRoute(T t, int n) {
        Args.notNull(t, (String)"Route");
        Args.positive((int)n, (String)"Max value");
        this.lock.lock();
        try {
            this.maxPerRoute.put(t, n);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxPerRoute(T t) {
        Args.notNull(t, (String)"Route");
        this.lock.lock();
        try {
            int n = this.getMax(t);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolStats getStats(T t) {
        Args.notNull(t, (String)"Route");
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t);
            PoolStats poolStats = new PoolStats(routeSpecificPool.getLeasedCount(), routeSpecificPool.getPendingCount(), routeSpecificPool.getAvailableCount(), this.getMax(t));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<T> getRoutes() {
        this.lock.lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.routeToPool.keySet());
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumAvailable(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                poolEntryCallback.process(poolEntry);
                if (!poolEntry.isClosed()) continue;
                RouteSpecificPool routeSpecificPool = this.getPool(poolEntry.getRoute());
                routeSpecificPool.remove(poolEntry);
                iterator.remove();
            }
            this.processPendingRequests();
            this.purgePoolMap();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumLeased(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            for (PoolEntry poolEntry : this.leased) {
                poolEntryCallback.process(poolEntry);
            }
            this.processPendingRequests();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    protected void enumEntries(Iterator<E> iterator, PoolEntryCallback<T, C> poolEntryCallback) {
        while (iterator.hasNext()) {
            PoolEntry poolEntry = (PoolEntry)iterator.next();
            poolEntryCallback.process(poolEntry);
        }
        this.processPendingRequests();
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, RouteSpecificPool<T, C, E>>> iterator = this.routeToPool.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, RouteSpecificPool<T, C, E>> entry = iterator.next();
            RouteSpecificPool<T, C, E> routeSpecificPool = entry.getValue();
            if (routeSpecificPool.getAllocatedCount() != 0) continue;
            iterator.remove();
        }
    }

    public void closeIdle(long l, TimeUnit timeUnit) {
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        long l2 = timeUnit.toMillis(l);
        if (l2 < 0L) {
            l2 = 0L;
        }
        final long l3 = System.currentTimeMillis() - l2;
        this.enumAvailable(new PoolEntryCallback<T, C>(){

            @Override
            public void process(PoolEntry<T, C> poolEntry) {
                if (poolEntry.getUpdated() <= l3) {
                    poolEntry.close();
                }
            }
        });
    }

    public void closeExpired() {
        final long l = System.currentTimeMillis();
        this.enumAvailable(new PoolEntryCallback<T, C>(){

            @Override
            public void process(PoolEntry<T, C> poolEntry) {
                if (poolEntry.isExpired(l)) {
                    poolEntry.close();
                }
            }
        });
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[leased: ");
        stringBuilder.append(this.leased);
        stringBuilder.append("][available: ");
        stringBuilder.append(this.available);
        stringBuilder.append("][pending: ");
        stringBuilder.append(this.pending);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    class InternalSessionRequestCallback
    implements SessionRequestCallback {
        InternalSessionRequestCallback() {
        }

        @Override
        public void completed(SessionRequest sessionRequest) {
            AbstractNIOConnPool.this.requestCompleted(sessionRequest);
        }

        @Override
        public void cancelled(SessionRequest sessionRequest) {
            AbstractNIOConnPool.this.requestCancelled(sessionRequest);
        }

        @Override
        public void failed(SessionRequest sessionRequest) {
            AbstractNIOConnPool.this.requestFailed(sessionRequest);
        }

        @Override
        public void timeout(SessionRequest sessionRequest) {
            AbstractNIOConnPool.this.requestTimeout(sessionRequest);
        }
    }
}

