/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAsyncResponseConsumer<T>
implements HttpAsyncResponseConsumer<T> {
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private volatile T result;
    private volatile Exception ex;

    protected abstract void onResponseReceived(HttpResponse var1) throws HttpException, IOException;

    protected abstract void onContentReceived(ContentDecoder var1, IOControl var2) throws IOException;

    protected abstract void onEntityEnclosed(HttpEntity var1, ContentType var2) throws IOException;

    protected abstract T buildResult(HttpContext var1) throws Exception;

    protected abstract void releaseResources();

    protected void onClose() throws IOException {
    }

    @Override
    public final void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        this.onResponseReceived(httpResponse);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            ContentType contentType = ContentType.getOrDefault(httpEntity);
            this.onEntityEnclosed(httpEntity, contentType);
        }
    }

    @Override
    public final void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        this.onContentReceived(contentDecoder, iOControl);
    }

    @Override
    public final void responseCompleted(HttpContext httpContext) {
        if (this.completed.compareAndSet(false, true)) {
            try {
                this.result = this.buildResult(httpContext);
            }
            catch (Exception exception) {
                this.ex = exception;
            }
            finally {
                this.releaseResources();
            }
        }
    }

    @Override
    public final boolean cancel() {
        if (this.completed.compareAndSet(false, true)) {
            this.releaseResources();
            return true;
        }
        return false;
    }

    @Override
    public final void failed(Exception exception) {
        if (this.completed.compareAndSet(false, true)) {
            this.ex = exception;
            this.releaseResources();
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.completed.compareAndSet(false, true)) {
            this.releaseResources();
            this.onClose();
        }
    }

    @Override
    public Exception getException() {
        return this.ex;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public boolean isDone() {
        return this.completed.get();
    }
}

