/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpClientHandler;
import com.icbc.api.internal.apache.http.nio.entity.ConsumingNHttpEntity;
import com.icbc.api.internal.apache.http.nio.entity.NHttpEntityWrapper;
import com.icbc.api.internal.apache.http.nio.entity.ProducingNHttpEntity;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpHandlerBase;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpRequestExecutionHandler;
import com.icbc.api.internal.apache.http.nio.protocol.NullNHttpEntity;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.DefaultedHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class AsyncNHttpClientHandler
extends NHttpHandlerBase
implements NHttpClientHandler {
    protected NHttpRequestExecutionHandler execHandler;

    public AsyncNHttpClientHandler(HttpProcessor httpProcessor, NHttpRequestExecutionHandler nHttpRequestExecutionHandler, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(httpProcessor, connectionReuseStrategy, byteBufferAllocator, httpParams);
        this.execHandler = (NHttpRequestExecutionHandler)Args.notNull((Object)nHttpRequestExecutionHandler, (String)"HTTP request execution handler");
    }

    public AsyncNHttpClientHandler(HttpProcessor httpProcessor, NHttpRequestExecutionHandler nHttpRequestExecutionHandler, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpProcessor, nHttpRequestExecutionHandler, connectionReuseStrategy, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    @Override
    public void connected(NHttpClientConnection nHttpClientConnection, Object object) {
        HttpContext httpContext = nHttpClientConnection.getContext();
        this.initialize(nHttpClientConnection, object);
        ClientConnState clientConnState = new ClientConnState();
        httpContext.setAttribute("http.nio.conn-state", clientConnState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen(nHttpClientConnection);
        }
        this.requestReady(nHttpClientConnection);
    }

    @Override
    public void closed(NHttpClientConnection nHttpClientConnection) {
        HttpContext httpContext;
        block3: {
            httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                clientConnState.reset();
            }
            catch (IOException iOException) {
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
        this.execHandler.finalizeContext(httpContext);
        if (this.eventListener != null) {
            this.eventListener.connectionClosed(nHttpClientConnection);
        }
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, HttpException httpException) {
        this.closeConnection(nHttpClientConnection, httpException);
        if (this.eventListener != null) {
            this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
        }
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, IOException iOException) {
        this.shutdownConnection(nHttpClientConnection, iOException);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(iOException, nHttpClientConnection);
        }
    }

    @Override
    public void requestReady(NHttpClientConnection nHttpClientConnection) {
        block13: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            if (clientConnState.getOutputState() != 0) {
                return;
            }
            try {
                HttpRequest httpRequest = this.execHandler.submitRequest(httpContext);
                if (httpRequest == null) {
                    return;
                }
                httpRequest.setParams(new DefaultedHttpParams(httpRequest.getParams(), this.params));
                httpContext.setAttribute("http.request", httpRequest);
                this.httpProcessor.process(httpRequest, httpContext);
                HttpEntityEnclosingRequest httpEntityEnclosingRequest = null;
                HttpEntity httpEntity = null;
                if (httpRequest instanceof HttpEntityEnclosingRequest) {
                    httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
                    httpEntity = httpEntityEnclosingRequest.getEntity();
                }
                if (httpEntity instanceof ProducingNHttpEntity) {
                    clientConnState.setProducingEntity((ProducingNHttpEntity)httpEntity);
                } else if (httpEntity != null) {
                    clientConnState.setProducingEntity(new NHttpEntityWrapper(httpEntity));
                }
                clientConnState.setRequest(httpRequest);
                nHttpClientConnection.submitRequest(httpRequest);
                clientConnState.setOutputState(1);
                if (httpEntityEnclosingRequest != null && httpEntityEnclosingRequest.expectContinue()) {
                    int n = nHttpClientConnection.getSocketTimeout();
                    clientConnState.setTimeout(n);
                    n = this.params.getIntParameter("http.protocol.wait-for-continue", 3000);
                    nHttpClientConnection.setSocketTimeout(n);
                    clientConnState.setOutputState(2);
                } else if (clientConnState.getProducingEntity() != null) {
                    clientConnState.setOutputState(4);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpClientConnection, httpException);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
            }
        }
    }

    @Override
    public void inputReady(NHttpClientConnection nHttpClientConnection, ContentDecoder contentDecoder) {
        block5: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            ConsumingNHttpEntity consumingNHttpEntity = clientConnState.getConsumingEntity();
            try {
                consumingNHttpEntity.consumeContent(contentDecoder, nHttpClientConnection);
                if (contentDecoder.isCompleted()) {
                    this.processResponse(nHttpClientConnection, clientConnState);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpClientConnection, httpException);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
            }
        }
    }

    @Override
    public void outputReady(NHttpClientConnection nHttpClientConnection, ContentEncoder contentEncoder) {
        block4: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                if (clientConnState.getOutputState() == 2) {
                    nHttpClientConnection.suspendOutput();
                    return;
                }
                ProducingNHttpEntity producingNHttpEntity = clientConnState.getProducingEntity();
                producingNHttpEntity.produceContent(contentEncoder, nHttpClientConnection);
                if (contentEncoder.isCompleted()) {
                    clientConnState.setOutputState(8);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
    }

    @Override
    public void responseReceived(NHttpClientConnection nHttpClientConnection) {
        block13: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            HttpResponse httpResponse = nHttpClientConnection.getHttpResponse();
            httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
            HttpRequest httpRequest = clientConnState.getRequest();
            try {
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n < 200) {
                    if (n == 100 && clientConnState.getOutputState() == 2) {
                        this.continueRequest(nHttpClientConnection, clientConnState);
                    }
                    return;
                }
                clientConnState.setResponse(httpResponse);
                if (clientConnState.getOutputState() == 2) {
                    this.cancelRequest(nHttpClientConnection, clientConnState);
                } else if (clientConnState.getOutputState() == 4) {
                    this.cancelRequest(nHttpClientConnection, clientConnState);
                    clientConnState.invalidate();
                    nHttpClientConnection.suspendOutput();
                }
                httpContext.setAttribute("http.response", httpResponse);
                if (!this.canResponseHaveBody(httpRequest, httpResponse)) {
                    nHttpClientConnection.resetInput();
                    httpResponse.setEntity(null);
                    this.httpProcessor.process(httpResponse, httpContext);
                    this.processResponse(nHttpClientConnection, clientConnState);
                } else {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        ConsumingNHttpEntity consumingNHttpEntity = this.execHandler.responseEntity(httpResponse, httpContext);
                        if (consumingNHttpEntity == null) {
                            consumingNHttpEntity = new NullNHttpEntity(httpEntity);
                        }
                        httpResponse.setEntity(consumingNHttpEntity);
                        clientConnState.setConsumingEntity(consumingNHttpEntity);
                        this.httpProcessor.process(httpResponse, httpContext);
                    }
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpClientConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpClientConnection, httpException);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(httpException, nHttpClientConnection);
            }
        }
    }

    @Override
    public void timeout(NHttpClientConnection nHttpClientConnection) {
        block3: {
            HttpContext httpContext = nHttpClientConnection.getContext();
            ClientConnState clientConnState = (ClientConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                if (clientConnState.getOutputState() == 2) {
                    this.continueRequest(nHttpClientConnection, clientConnState);
                    return;
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpClientConnection, iOException);
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(iOException, nHttpClientConnection);
            }
        }
        this.handleTimeout(nHttpClientConnection);
    }

    private void initialize(NHttpClientConnection nHttpClientConnection, Object object) {
        HttpContext httpContext = nHttpClientConnection.getContext();
        httpContext.setAttribute("http.connection", nHttpClientConnection);
        this.execHandler.initalizeContext(httpContext, object);
    }

    private void continueRequest(NHttpClientConnection nHttpClientConnection, ClientConnState clientConnState) throws IOException {
        int n = clientConnState.getTimeout();
        nHttpClientConnection.setSocketTimeout(n);
        nHttpClientConnection.requestOutput();
        clientConnState.setOutputState(4);
    }

    private void cancelRequest(NHttpClientConnection nHttpClientConnection, ClientConnState clientConnState) throws IOException {
        int n = clientConnState.getTimeout();
        nHttpClientConnection.setSocketTimeout(n);
        nHttpClientConnection.resetOutput();
        clientConnState.resetOutput();
    }

    private void processResponse(NHttpClientConnection nHttpClientConnection, ClientConnState clientConnState) throws IOException, HttpException {
        if (!clientConnState.isValid()) {
            nHttpClientConnection.close();
        }
        HttpContext httpContext = nHttpClientConnection.getContext();
        HttpResponse httpResponse = clientConnState.getResponse();
        this.execHandler.handleResponse(httpResponse, httpContext);
        if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
            nHttpClientConnection.close();
        }
        if (nHttpClientConnection.isOpen()) {
            clientConnState.resetInput();
            clientConnState.resetOutput();
            nHttpClientConnection.requestOutput();
        }
    }

    protected static class ClientConnState {
        public static final int READY = 0;
        public static final int REQUEST_SENT = 1;
        public static final int EXPECT_CONTINUE = 2;
        public static final int REQUEST_BODY_STREAM = 4;
        public static final int REQUEST_BODY_DONE = 8;
        public static final int RESPONSE_RECEIVED = 16;
        public static final int RESPONSE_BODY_STREAM = 32;
        public static final int RESPONSE_BODY_DONE = 64;
        private int outputState;
        private HttpRequest request;
        private HttpResponse response;
        private ConsumingNHttpEntity consumingEntity;
        private ProducingNHttpEntity producingEntity;
        private boolean valid = true;
        private int timeout;

        public void setConsumingEntity(ConsumingNHttpEntity consumingNHttpEntity) {
            this.consumingEntity = consumingNHttpEntity;
        }

        public void setProducingEntity(ProducingNHttpEntity producingNHttpEntity) {
            this.producingEntity = producingNHttpEntity;
        }

        public ProducingNHttpEntity getProducingEntity() {
            return this.producingEntity;
        }

        public ConsumingNHttpEntity getConsumingEntity() {
            return this.consumingEntity;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int n) {
            this.outputState = n;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public void resetInput() throws IOException {
            this.response = null;
            if (this.consumingEntity != null) {
                this.consumingEntity.finish();
                this.consumingEntity = null;
            }
        }

        public void resetOutput() throws IOException {
            this.request = null;
            if (this.producingEntity != null) {
                this.producingEntity.finish();
                this.producingEntity = null;
            }
            this.outputState = 0;
        }

        public void reset() throws IOException {
            this.resetInput();
            this.resetOutput();
        }

        public boolean isValid() {
            return this.valid;
        }

        public void invalidate() {
            this.valid = false;
        }
    }
}

