/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.MethodNotSupportedException;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.UnsupportedHttpVersionException;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpServerConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServiceHandler;
import com.icbc.api.internal.apache.http.nio.entity.ConsumingNHttpEntity;
import com.icbc.api.internal.apache.http.nio.entity.NByteArrayEntity;
import com.icbc.api.internal.apache.http.nio.entity.NHttpEntityWrapper;
import com.icbc.api.internal.apache.http.nio.entity.ProducingNHttpEntity;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpHandlerBase;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpRequestHandler;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpRequestHandlerResolver;
import com.icbc.api.internal.apache.http.nio.protocol.NHttpResponseTrigger;
import com.icbc.api.internal.apache.http.nio.protocol.NullNHttpEntity;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.DefaultedHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpExpectationVerifier;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import com.icbc.api.internal.apache.http.util.EncodingUtils;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class AsyncNHttpServiceHandler
extends NHttpHandlerBase
implements NHttpServiceHandler {
    protected final HttpResponseFactory responseFactory;
    protected NHttpRequestHandlerResolver handlerResolver;
    protected HttpExpectationVerifier expectationVerifier;

    public AsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(httpProcessor, connectionReuseStrategy, byteBufferAllocator, httpParams);
        Args.notNull((Object)httpResponseFactory, (String)"Response factory");
        this.responseFactory = httpResponseFactory;
    }

    public AsyncNHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpProcessor, httpResponseFactory, connectionReuseStrategy, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    public void setExpectationVerifier(HttpExpectationVerifier httpExpectationVerifier) {
        this.expectationVerifier = httpExpectationVerifier;
    }

    public void setHandlerResolver(NHttpRequestHandlerResolver nHttpRequestHandlerResolver) {
        this.handlerResolver = nHttpRequestHandlerResolver;
    }

    @Override
    public void connected(NHttpServerConnection nHttpServerConnection) {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = new ServerConnState();
        httpContext.setAttribute("http.nio.conn-state", serverConnState);
        httpContext.setAttribute("http.connection", nHttpServerConnection);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen(nHttpServerConnection);
        }
    }

    @Override
    public void requestReceived(NHttpServerConnection nHttpServerConnection) {
        block14: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            HttpRequest httpRequest = nHttpServerConnection.getHttpRequest();
            httpRequest.setParams(new DefaultedHttpParams(httpRequest.getParams(), this.params));
            serverConnState.setRequest(httpRequest);
            NHttpRequestHandler nHttpRequestHandler = this.getRequestHandler(httpRequest);
            serverConnState.setRequestHandler(nHttpRequestHandler);
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            if (!protocolVersion.lessEquals(HttpVersion.HTTP_1_1)) {
                protocolVersion = HttpVersion.HTTP_1_1;
            }
            try {
                if (httpRequest instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
                    if (httpEntityEnclosingRequest.expectContinue()) {
                        HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 100, httpContext);
                        httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                        if (this.expectationVerifier != null) {
                            try {
                                this.expectationVerifier.verify(httpRequest, httpResponse, httpContext);
                            }
                            catch (HttpException httpException) {
                                httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                                this.handleException(httpException, httpResponse);
                            }
                        }
                        if (httpResponse.getStatusLine().getStatusCode() < 200) {
                            nHttpServerConnection.submitResponse(httpResponse);
                        } else {
                            nHttpServerConnection.resetInput();
                            this.sendResponse(nHttpServerConnection, httpRequest, httpResponse);
                        }
                    }
                    ConsumingNHttpEntity consumingNHttpEntity = null;
                    if (nHttpRequestHandler != null) {
                        consumingNHttpEntity = nHttpRequestHandler.entityRequest(httpEntityEnclosingRequest, httpContext);
                    }
                    if (consumingNHttpEntity == null) {
                        consumingNHttpEntity = new NullNHttpEntity(httpEntityEnclosingRequest.getEntity());
                    }
                    httpEntityEnclosingRequest.setEntity(consumingNHttpEntity);
                    serverConnState.setConsumingEntity(consumingNHttpEntity);
                    break block14;
                }
                nHttpServerConnection.suspendInput();
                this.processRequest(nHttpServerConnection, httpRequest);
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpServerConnection, httpException);
                if (this.eventListener == null) break block14;
                this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
            }
        }
    }

    @Override
    public void closed(NHttpServerConnection nHttpServerConnection) {
        block3: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            try {
                serverConnState.reset();
            }
            catch (IOException iOException) {
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(iOException, nHttpServerConnection);
            }
        }
        if (this.eventListener != null) {
            this.eventListener.connectionClosed(nHttpServerConnection);
        }
    }

    @Override
    public void exception(NHttpServerConnection nHttpServerConnection, HttpException httpException) {
        block6: {
            if (nHttpServerConnection.isResponseSubmitted()) {
                this.closeConnection(nHttpServerConnection, httpException);
                if (this.eventListener != null) {
                    this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
                }
                return;
            }
            HttpContext httpContext = nHttpServerConnection.getContext();
            try {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                this.handleException(httpException, httpResponse);
                httpResponse.setEntity(null);
                this.sendResponse(nHttpServerConnection, null, httpResponse);
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException2) {
                this.closeConnection(nHttpServerConnection, httpException2);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalProtocolException(httpException2, nHttpServerConnection);
            }
        }
    }

    @Override
    public void exception(NHttpServerConnection nHttpServerConnection, IOException iOException) {
        this.shutdownConnection(nHttpServerConnection, iOException);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(iOException, nHttpServerConnection);
        }
    }

    @Override
    public void timeout(NHttpServerConnection nHttpServerConnection) {
        this.handleTimeout(nHttpServerConnection);
    }

    @Override
    public void inputReady(NHttpServerConnection nHttpServerConnection, ContentDecoder contentDecoder) {
        block5: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            HttpRequest httpRequest = serverConnState.getRequest();
            ConsumingNHttpEntity consumingNHttpEntity = serverConnState.getConsumingEntity();
            try {
                consumingNHttpEntity.consumeContent(contentDecoder, nHttpServerConnection);
                if (contentDecoder.isCompleted()) {
                    nHttpServerConnection.suspendInput();
                    this.processRequest(nHttpServerConnection, httpRequest);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpServerConnection, httpException);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
            }
        }
    }

    @Override
    public void responseReady(NHttpServerConnection nHttpServerConnection) {
        block8: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            if (serverConnState.isHandled()) {
                return;
            }
            HttpRequest httpRequest = serverConnState.getRequest();
            try {
                HttpResponse httpResponse;
                IOException iOException = serverConnState.getIOException();
                if (iOException != null) {
                    throw iOException;
                }
                HttpException httpException = serverConnState.getHttpException();
                if (httpException != null) {
                    httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_0, 500, httpContext);
                    httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                    this.handleException(httpException, httpResponse);
                    serverConnState.setResponse(httpResponse);
                }
                if ((httpResponse = serverConnState.getResponse()) != null) {
                    serverConnState.setHandled(true);
                    this.sendResponse(nHttpServerConnection, httpRequest, httpResponse);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection(nHttpServerConnection, httpException);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalProtocolException(httpException, nHttpServerConnection);
            }
        }
    }

    @Override
    public void outputReady(NHttpServerConnection nHttpServerConnection, ContentEncoder contentEncoder) {
        block5: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            HttpResponse httpResponse = nHttpServerConnection.getHttpResponse();
            try {
                ProducingNHttpEntity producingNHttpEntity = serverConnState.getProducingEntity();
                producingNHttpEntity.produceContent(contentEncoder, nHttpServerConnection);
                if (contentEncoder.isCompleted()) {
                    serverConnState.finishOutput();
                    if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                        nHttpServerConnection.close();
                    } else {
                        serverConnState.reset();
                        nHttpServerConnection.requestInput();
                    }
                    this.responseComplete(httpResponse, httpContext);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection(nHttpServerConnection, iOException);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalIOException(iOException, nHttpServerConnection);
            }
        }
    }

    private void handleException(HttpException httpException, HttpResponse httpResponse) {
        int n = 500;
        if (httpException instanceof MethodNotSupportedException) {
            n = 501;
        } else if (httpException instanceof UnsupportedHttpVersionException) {
            n = 505;
        } else if (httpException instanceof ProtocolException) {
            n = 400;
        }
        httpResponse.setStatusCode(n);
        byte[] byArray = EncodingUtils.getAsciiBytes(httpException.getMessage());
        NByteArrayEntity nByteArrayEntity = new NByteArrayEntity(byArray);
        nByteArrayEntity.setContentType("text/plain; charset=US-ASCII");
        httpResponse.setEntity(nByteArrayEntity);
    }

    private void processRequest(NHttpServerConnection nHttpServerConnection, HttpRequest httpRequest) throws IOException, HttpException {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        if (!protocolVersion.lessEquals(HttpVersion.HTTP_1_1)) {
            protocolVersion = HttpVersion.HTTP_1_1;
        }
        ResponseTriggerImpl responseTriggerImpl = new ResponseTriggerImpl(serverConnState, nHttpServerConnection);
        try {
            this.httpProcessor.process(httpRequest, httpContext);
            NHttpRequestHandler nHttpRequestHandler = serverConnState.getRequestHandler();
            if (nHttpRequestHandler != null) {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 200, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                nHttpRequestHandler.handle(httpRequest, httpResponse, responseTriggerImpl, httpContext);
            } else {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 501, httpContext);
                httpResponse.setParams(new DefaultedHttpParams(httpResponse.getParams(), this.params));
                responseTriggerImpl.submitResponse(httpResponse);
            }
        }
        catch (HttpException httpException) {
            responseTriggerImpl.handleException(httpException);
        }
    }

    private void sendResponse(NHttpServerConnection nHttpServerConnection, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException, HttpException {
        HttpEntity httpEntity;
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        serverConnState.finishInput();
        httpContext.setAttribute("http.request", httpRequest);
        this.httpProcessor.process(httpResponse, httpContext);
        httpContext.setAttribute("http.request", null);
        if (httpResponse.getEntity() != null && !this.canResponseHaveBody(httpRequest, httpResponse)) {
            httpResponse.setEntity(null);
        }
        if ((httpEntity = httpResponse.getEntity()) != null) {
            if (httpEntity instanceof ProducingNHttpEntity) {
                serverConnState.setProducingEntity((ProducingNHttpEntity)httpEntity);
            } else {
                serverConnState.setProducingEntity(new NHttpEntityWrapper(httpEntity));
            }
        }
        nHttpServerConnection.submitResponse(httpResponse);
        if (httpEntity == null) {
            if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                nHttpServerConnection.close();
            } else {
                serverConnState.reset();
                nHttpServerConnection.requestInput();
            }
            this.responseComplete(httpResponse, httpContext);
        }
    }

    protected void responseComplete(HttpResponse httpResponse, HttpContext httpContext) {
    }

    private NHttpRequestHandler getRequestHandler(HttpRequest httpRequest) {
        NHttpRequestHandler nHttpRequestHandler = null;
        if (this.handlerResolver != null) {
            String string = httpRequest.getRequestLine().getUri();
            nHttpRequestHandler = this.handlerResolver.lookup(string);
        }
        return nHttpRequestHandler;
    }

    private static class ResponseTriggerImpl
    implements NHttpResponseTrigger {
        private final ServerConnState connState;
        private final IOControl iocontrol;
        private volatile boolean triggered;

        public ResponseTriggerImpl(ServerConnState serverConnState, IOControl iOControl) {
            this.connState = serverConnState;
            this.iocontrol = iOControl;
        }

        @Override
        public void submitResponse(HttpResponse httpResponse) {
            Args.notNull((Object)httpResponse, (String)"Response");
            Asserts.check((!this.triggered ? 1 : 0) != 0, (String)"Response already triggered");
            this.triggered = true;
            this.connState.setResponse(httpResponse);
            this.iocontrol.requestOutput();
        }

        @Override
        public void handleException(HttpException httpException) {
            Asserts.check((!this.triggered ? 1 : 0) != 0, (String)"Response already triggered");
            this.triggered = true;
            this.connState.setHttpException(httpException);
            this.iocontrol.requestOutput();
        }

        @Override
        public void handleException(IOException iOException) {
            Asserts.check((!this.triggered ? 1 : 0) != 0, (String)"Response already triggered");
            this.triggered = true;
            this.connState.setIOException(iOException);
            this.iocontrol.requestOutput();
        }
    }

    protected static class ServerConnState {
        private volatile NHttpRequestHandler requestHandler;
        private volatile HttpRequest request;
        private volatile ConsumingNHttpEntity consumingEntity;
        private volatile HttpResponse response;
        private volatile ProducingNHttpEntity producingEntity;
        private volatile IOException ioex;
        private volatile HttpException httpex;
        private volatile boolean handled;

        protected ServerConnState() {
        }

        public void finishInput() throws IOException {
            if (this.consumingEntity != null) {
                this.consumingEntity.finish();
                this.consumingEntity = null;
            }
        }

        public void finishOutput() throws IOException {
            if (this.producingEntity != null) {
                this.producingEntity.finish();
                this.producingEntity = null;
            }
        }

        public void reset() throws IOException {
            this.finishInput();
            this.request = null;
            this.finishOutput();
            this.handled = false;
            this.response = null;
            this.ioex = null;
            this.httpex = null;
            this.requestHandler = null;
        }

        public NHttpRequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        public void setRequestHandler(NHttpRequestHandler nHttpRequestHandler) {
            this.requestHandler = nHttpRequestHandler;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public ConsumingNHttpEntity getConsumingEntity() {
            return this.consumingEntity;
        }

        public void setConsumingEntity(ConsumingNHttpEntity consumingNHttpEntity) {
            this.consumingEntity = consumingNHttpEntity;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public ProducingNHttpEntity getProducingEntity() {
            return this.producingEntity;
        }

        public void setProducingEntity(ProducingNHttpEntity producingNHttpEntity) {
            this.producingEntity = producingNHttpEntity;
        }

        public IOException getIOException() {
            return this.ioex;
        }

        public IOException getIOExepction() {
            return this.ioex;
        }

        public void setIOException(IOException iOException) {
            this.ioex = iOException;
        }

        public void setIOExepction(IOException iOException) {
            this.ioex = iOException;
        }

        public HttpException getHttpException() {
            return this.httpex;
        }

        public HttpException getHttpExepction() {
            return this.httpex;
        }

        public void setHttpException(HttpException httpException) {
            this.httpex = httpException;
        }

        public void setHttpExepction(HttpException httpException) {
            this.httpex = httpException;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void setHandled(boolean bl) {
            this.handled = bl;
        }
    }
}

