/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncExchange;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpRequestHandler;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler httpRequestHandler) {
        Args.notNull((Object)httpRequestHandler, (String)"Request handler");
        this.handler = httpRequestHandler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest httpRequest, HttpContext httpContext) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpAsyncExchange httpAsyncExchange, HttpContext httpContext) throws HttpException, IOException {
        this.handler.handle(httpRequest, httpAsyncExchange.getResponse(), httpContext);
        httpAsyncExchange.submitResponse();
    }
}

