/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ContentTooLongException;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.ContentBufferEntity;
import com.icbc.api.internal.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.SimpleInputBuffer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse httpResponse) throws IOException {
        this.response = httpResponse;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity httpEntity, ContentType contentType) throws IOException {
        long l = httpEntity.getContentLength();
        if (l > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + l);
        }
        if (l < 0L) {
            l = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)l, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(httpEntity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        Asserts.notNull((Object)this.buf, (String)"Content buffer");
        this.buf.consumeContent(contentDecoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext httpContext) {
        return this.response;
    }
}

