/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.entity.EntityAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.entity.HttpAsyncContentProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseProducer;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

public class BasicAsyncResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncResponseProducer(HttpResponse httpResponse, HttpAsyncContentProducer httpAsyncContentProducer) {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        Args.notNull((Object)httpAsyncContentProducer, (String)"HTTP content producer");
        this.response = httpResponse;
        this.producer = httpAsyncContentProducer;
    }

    public BasicAsyncResponseProducer(HttpResponse httpResponse) {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        this.response = httpResponse;
        HttpEntity httpEntity = httpResponse.getEntity();
        this.producer = httpEntity != null ? (httpEntity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)httpEntity) : new EntityAsyncContentProducer(httpEntity)) : null;
    }

    @Override
    public HttpResponse generateResponse() {
        return this.response;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(contentEncoder, iOControl);
            if (contentEncoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    @Override
    public void responseCompleted(HttpContext httpContext) {
    }

    @Override
    public void failed(Exception exception) {
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.response);
        if (this.producer != null) {
            stringBuilder.append(" ").append(this.producer);
        }
        return stringBuilder.toString();
    }
}

