/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.ProtocolVersion;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.NHttpConnection;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.protocol.MessageState;
import com.icbc.api.internal.apache.http.nio.protocol.Pipelined;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpAsyncRequestExecutor
implements NHttpClientEventHandler {
    public static final int DEFAULT_WAIT_FOR_CONTINUE = 3000;
    public static final String HTTP_HANDLER = "http.nio.exchange-handler";
    private final int waitForContinue;
    private final ExceptionLogger exceptionLogger;
    static final String HTTP_EXCHANGE_STATE = "http.nio.http-exchange-state";

    public HttpAsyncRequestExecutor(int n, ExceptionLogger exceptionLogger) {
        this.waitForContinue = Args.positive((int)n, (String)"Wait for continue time");
        this.exceptionLogger = exceptionLogger != null ? exceptionLogger : ExceptionLogger.NO_OP;
    }

    public HttpAsyncRequestExecutor(int n) {
        this(n, null);
    }

    public HttpAsyncRequestExecutor() {
        this(3000, null);
    }

    @Override
    public void connected(NHttpClientConnection nHttpClientConnection, Object object) throws IOException, HttpException {
        State state = new State();
        HttpContext httpContext = nHttpClientConnection.getContext();
        httpContext.setAttribute(HTTP_EXCHANGE_STATE, state);
        this.requestReady(nHttpClientConnection);
    }

    @Override
    public void closed(NHttpClientConnection nHttpClientConnection) {
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
        if (state != null && (state.getRequestState() != MessageState.READY || state.getResponseState() != MessageState.READY) && httpAsyncClientExchangeHandler != null) {
            httpAsyncClientExchangeHandler.failed(new ConnectionClosedException("Connection closed unexpectedly"));
        }
        if (state == null || httpAsyncClientExchangeHandler != null && httpAsyncClientExchangeHandler.isDone()) {
            this.closeHandler(httpAsyncClientExchangeHandler);
        }
    }

    @Override
    public void exception(NHttpClientConnection nHttpClientConnection, Exception exception) {
        this.shutdownConnection(nHttpClientConnection);
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
        if (httpAsyncClientExchangeHandler != null) {
            httpAsyncClientExchangeHandler.failed(exception);
        } else {
            this.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReady(NHttpClientConnection nHttpClientConnection) throws IOException, HttpException {
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler;
        HttpContext httpContext;
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.READY || state.getRequestState() == MessageState.COMPLETED ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        if (state.getRequestState() == MessageState.COMPLETED) {
            nHttpClientConnection.suspendOutput();
            return;
        }
        HttpContext httpContext2 = httpContext = nHttpClientConnection.getContext();
        synchronized (httpContext2) {
            httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
            if (httpAsyncClientExchangeHandler == null || httpAsyncClientExchangeHandler.isDone()) {
                nHttpClientConnection.suspendOutput();
                return;
            }
        }
        boolean bl = httpAsyncClientExchangeHandler.getClass().getAnnotation(Pipelined.class) != null;
        HttpRequest httpRequest = httpAsyncClientExchangeHandler.generateRequest();
        if (httpRequest == null) {
            nHttpClientConnection.suspendOutput();
            return;
        }
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        if (bl && protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
            throw new ProtocolException(protocolVersion + " cannot be used with request pipelining");
        }
        state.setRequest(httpRequest);
        if (bl) {
            state.getRequestQueue().add(httpRequest);
        }
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            boolean bl2 = ((HttpEntityEnclosingRequest)httpRequest).expectContinue();
            if (bl2 && bl) {
                throw new ProtocolException("Expect-continue handshake cannot be used with request pipelining");
            }
            nHttpClientConnection.submitRequest(httpRequest);
            if (bl2) {
                int n = nHttpClientConnection.getSocketTimeout();
                state.setTimeout(n);
                nHttpClientConnection.setSocketTimeout(this.waitForContinue);
                state.setRequestState(MessageState.ACK_EXPECTED);
            } else {
                HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                if (httpEntity != null) {
                    state.setRequestState(MessageState.BODY_STREAM);
                } else {
                    httpAsyncClientExchangeHandler.requestCompleted();
                    state.setRequestState(bl ? MessageState.READY : MessageState.COMPLETED);
                }
            }
        } else {
            nHttpClientConnection.submitRequest(httpRequest);
            httpAsyncClientExchangeHandler.requestCompleted();
            state.setRequestState(bl ? MessageState.READY : MessageState.COMPLETED);
        }
    }

    @Override
    public void outputReady(NHttpClientConnection nHttpClientConnection, ContentEncoder contentEncoder) throws IOException, HttpException {
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.BODY_STREAM || state.getRequestState() == MessageState.ACK_EXPECTED ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
        Asserts.notNull((Object)httpAsyncClientExchangeHandler, (String)"Client exchange handler");
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            nHttpClientConnection.suspendOutput();
            return;
        }
        httpAsyncClientExchangeHandler.produceContent(contentEncoder, nHttpClientConnection);
        if (contentEncoder.isCompleted()) {
            httpAsyncClientExchangeHandler.requestCompleted();
            boolean bl = httpAsyncClientExchangeHandler.getClass().getAnnotation(Pipelined.class) != null;
            state.setRequestState(bl ? MessageState.READY : MessageState.COMPLETED);
        }
    }

    @Override
    public void responseReceived(NHttpClientConnection nHttpClientConnection) throws HttpException, IOException {
        HttpRequest httpRequest;
        boolean bl;
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.READY ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getResponseState());
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
        Asserts.notNull((Object)httpAsyncClientExchangeHandler, (String)"Client exchange handler");
        boolean bl2 = bl = httpAsyncClientExchangeHandler.getClass().getAnnotation(Pipelined.class) != null;
        if (bl) {
            httpRequest = state.getRequestQueue().poll();
            Asserts.notNull((Object)httpRequest, (String)"HTTP request");
        } else {
            httpRequest = state.getRequest();
            if (httpRequest == null) {
                throw new HttpException("Out of sequence response");
            }
        }
        HttpResponse httpResponse = nHttpClientConnection.getHttpResponse();
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n < 200) {
            if (n != 100) {
                throw new ProtocolException("Unexpected response: " + httpResponse.getStatusLine());
            }
            if (state.getRequestState() == MessageState.ACK_EXPECTED) {
                int n2 = state.getTimeout();
                nHttpClientConnection.setSocketTimeout(n2);
                nHttpClientConnection.requestOutput();
                state.setRequestState(MessageState.BODY_STREAM);
            }
            return;
        }
        state.setResponse(httpResponse);
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            int n3 = state.getTimeout();
            nHttpClientConnection.setSocketTimeout(n3);
            nHttpClientConnection.resetOutput();
            state.setRequestState(MessageState.COMPLETED);
        } else if (state.getRequestState() == MessageState.BODY_STREAM) {
            nHttpClientConnection.resetOutput();
            nHttpClientConnection.suspendOutput();
            state.setRequestState(MessageState.COMPLETED);
            state.invalidate();
        }
        httpAsyncClientExchangeHandler.responseReceived(httpResponse);
        state.setResponseState(MessageState.BODY_STREAM);
        if (!this.canResponseHaveBody(httpRequest, httpResponse)) {
            httpResponse.setEntity(null);
            nHttpClientConnection.resetInput();
            this.processResponse(nHttpClientConnection, state, httpAsyncClientExchangeHandler);
        }
    }

    @Override
    public void inputReady(NHttpClientConnection nHttpClientConnection, ContentDecoder contentDecoder) throws IOException, HttpException {
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.BODY_STREAM ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getResponseState());
        HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
        Asserts.notNull((Object)httpAsyncClientExchangeHandler, (String)"Client exchange handler");
        httpAsyncClientExchangeHandler.consumeContent(contentDecoder, nHttpClientConnection);
        if (contentDecoder.isCompleted()) {
            this.processResponse(nHttpClientConnection, state, httpAsyncClientExchangeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOfInput(NHttpClientConnection nHttpClientConnection) throws IOException {
        HttpContext httpContext;
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        HttpContext httpContext2 = httpContext = nHttpClientConnection.getContext();
        synchronized (httpContext2) {
            if (state != null) {
                HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler;
                if (state.getRequestState().compareTo((Enum)MessageState.READY) != 0) {
                    state.invalidate();
                }
                if ((httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection)) != null) {
                    if (state.isValid()) {
                        httpAsyncClientExchangeHandler.inputTerminated();
                    } else {
                        httpAsyncClientExchangeHandler.failed(new ConnectionClosedException("Connection closed"));
                    }
                }
            }
            if (nHttpClientConnection.getSocketTimeout() <= 0) {
                nHttpClientConnection.setSocketTimeout(1000);
            }
            nHttpClientConnection.close();
        }
    }

    @Override
    public void timeout(NHttpClientConnection nHttpClientConnection) throws IOException {
        State state = HttpAsyncRequestExecutor.getState(nHttpClientConnection);
        if (state != null) {
            if (state.getRequestState() == MessageState.ACK_EXPECTED) {
                int n = state.getTimeout();
                nHttpClientConnection.setSocketTimeout(n);
                nHttpClientConnection.requestOutput();
                state.setRequestState(MessageState.BODY_STREAM);
                state.setTimeout(0);
                return;
            }
            state.invalidate();
            HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler = HttpAsyncRequestExecutor.getHandler(nHttpClientConnection);
            if (httpAsyncClientExchangeHandler != null) {
                httpAsyncClientExchangeHandler.failed(new SocketTimeoutException());
                httpAsyncClientExchangeHandler.close();
            }
        }
        if (nHttpClientConnection.getStatus() == 0) {
            nHttpClientConnection.close();
            if (nHttpClientConnection.getStatus() == 1) {
                nHttpClientConnection.setSocketTimeout(250);
            }
        } else {
            nHttpClientConnection.shutdown();
        }
    }

    protected void log(Exception exception) {
        this.exceptionLogger.log(exception);
    }

    private static State getState(NHttpConnection nHttpConnection) {
        return (State)nHttpConnection.getContext().getAttribute(HTTP_EXCHANGE_STATE);
    }

    private static HttpAsyncClientExchangeHandler getHandler(NHttpConnection nHttpConnection) {
        return (HttpAsyncClientExchangeHandler)nHttpConnection.getContext().getAttribute(HTTP_HANDLER);
    }

    private void shutdownConnection(NHttpConnection nHttpConnection) {
        try {
            nHttpConnection.shutdown();
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
    }

    private void closeHandler(HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler) {
        if (httpAsyncClientExchangeHandler != null) {
            try {
                httpAsyncClientExchangeHandler.close();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
    }

    private void processResponse(NHttpClientConnection nHttpClientConnection, State state, HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler) throws IOException, HttpException {
        boolean bl;
        if (!state.isValid()) {
            nHttpClientConnection.close();
        }
        httpAsyncClientExchangeHandler.responseCompleted();
        boolean bl2 = bl = httpAsyncClientExchangeHandler.getClass().getAnnotation(Pipelined.class) != null;
        if (!bl) {
            state.setRequestState(MessageState.READY);
            state.setRequest(null);
        }
        state.setResponseState(MessageState.READY);
        state.setResponse(null);
        if (!httpAsyncClientExchangeHandler.isDone() && nHttpClientConnection.isOpen()) {
            nHttpClientConnection.requestOutput();
        }
    }

    private boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        String string = httpRequest.getRequestLine().getMethod();
        int n = httpResponse.getStatusLine().getStatusCode();
        if (string.equalsIgnoreCase("HEAD")) {
            return false;
        }
        if (string.equalsIgnoreCase("CONNECT") && n < 300) {
            return false;
        }
        return n >= 200 && n != 204 && n != 304 && n != 205;
    }

    static class State {
        private final Queue<HttpRequest> requestQueue = new ConcurrentLinkedQueue<HttpRequest>();
        private volatile MessageState requestState = MessageState.READY;
        private volatile MessageState responseState = MessageState.READY;
        private volatile HttpRequest request;
        private volatile HttpResponse response;
        private volatile boolean valid = true;
        private volatile int timeout;

        State() {
        }

        public MessageState getRequestState() {
            return this.requestState;
        }

        public void setRequestState(MessageState messageState) {
            this.requestState = messageState;
        }

        public MessageState getResponseState() {
            return this.responseState;
        }

        public void setResponseState(MessageState messageState) {
            this.responseState = messageState;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public Queue<HttpRequest> getRequestQueue() {
            return this.requestQueue;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void invalidate() {
            this.valid = false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("request state: ");
            stringBuilder.append(this.requestState);
            stringBuilder.append("; request: ");
            if (this.request != null) {
                stringBuilder.append(this.request.getRequestLine());
            }
            stringBuilder.append("; response state: ");
            stringBuilder.append(this.responseState);
            stringBuilder.append("; response: ");
            if (this.response != null) {
                stringBuilder.append(this.response.getStatusLine());
            }
            stringBuilder.append("; valid: ");
            stringBuilder.append(this.valid);
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
    }
}

