/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.protocol.BasicAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.PipeliningClientExchangeHandler;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.pool.ConnPool;
import com.icbc.api.internal.apache.http.pool.PoolEntry;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpAsyncRequester {
    private final HttpProcessor httpprocessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ExceptionLogger exceptionLogger;

    @Deprecated
    public HttpAsyncRequester(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpProcessor, connectionReuseStrategy);
    }

    public HttpAsyncRequester(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ExceptionLogger exceptionLogger) {
        this.httpprocessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.connReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.exceptionLogger = exceptionLogger != null ? exceptionLogger : ExceptionLogger.NO_OP;
    }

    public HttpAsyncRequester(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy) {
        this(httpProcessor, connectionReuseStrategy, (ExceptionLogger)null);
    }

    public HttpAsyncRequester(HttpProcessor httpProcessor) {
        this(httpProcessor, null);
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, NHttpClientConnection nHttpClientConnection, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull((Object)httpAsyncRequestProducer, (String)"HTTP request producer");
        Args.notNull(httpAsyncResponseConsumer, (String)"HTTP response consumer");
        Args.notNull((Object)nHttpClientConnection, (String)"HTTP connection");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        BasicAsyncClientExchangeHandler<T> basicAsyncClientExchangeHandler = new BasicAsyncClientExchangeHandler<T>(httpAsyncRequestProducer, httpAsyncResponseConsumer, futureCallback, httpContext, nHttpClientConnection, this.httpprocessor, this.connReuseStrategy);
        this.initExecution(basicAsyncClientExchangeHandler, nHttpClientConnection);
        return basicAsyncClientExchangeHandler.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecution(HttpAsyncClientExchangeHandler httpAsyncClientExchangeHandler, NHttpClientConnection nHttpClientConnection) {
        HttpContext httpContext;
        HttpContext httpContext2 = httpContext = nHttpClientConnection.getContext();
        synchronized (httpContext2) {
            httpContext.setAttribute("http.nio.exchange-handler", httpAsyncClientExchangeHandler);
            if (!nHttpClientConnection.isOpen()) {
                httpAsyncClientExchangeHandler.failed(new ConnectionClosedException("Connection closed"));
            } else {
                nHttpClientConnection.requestOutput();
            }
        }
        if (httpAsyncClientExchangeHandler.isDone()) {
            try {
                httpAsyncClientExchangeHandler.close();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, NHttpClientConnection nHttpClientConnection, HttpContext httpContext) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, nHttpClientConnection, httpContext, null);
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, NHttpClientConnection nHttpClientConnection) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, nHttpClientConnection, (HttpContext)new BasicHttpContext());
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, ConnPool<HttpHost, E> connPool, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull((Object)httpAsyncRequestProducer, (String)"HTTP request producer");
        Args.notNull(httpAsyncResponseConsumer, (String)"HTTP response consumer");
        Args.notNull(connPool, (String)"HTTP connection pool");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        BasicFuture<T> basicFuture = new BasicFuture<T>(futureCallback);
        HttpHost httpHost = httpAsyncRequestProducer.getTarget();
        connPool.lease(httpHost, null, new ConnRequestCallback<T, E>(basicFuture, httpAsyncRequestProducer, httpAsyncResponseConsumer, connPool, httpContext));
        return basicFuture;
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<List<T>> executePipelined(HttpHost httpHost, List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, ConnPool<HttpHost, E> connPool, HttpContext httpContext, FutureCallback<List<T>> futureCallback) {
        Args.notNull((Object)httpHost, (String)"HTTP target");
        Args.notEmpty(list, (String)"Request producer list");
        Args.notEmpty(list2, (String)"Response consumer list");
        Args.notNull(connPool, (String)"HTTP connection pool");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        BasicFuture<List<T>> basicFuture = new BasicFuture<List<T>>(futureCallback);
        connPool.lease(httpHost, null, new ConnPipelinedRequestCallback<T, E>(basicFuture, list, list2, connPool, httpContext));
        return basicFuture;
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, E e, ConnPool<HttpHost, E> connPool, HttpContext httpContext, FutureCallback<T> futureCallback) {
        Args.notNull((Object)httpAsyncRequestProducer, (String)"HTTP request producer");
        Args.notNull(httpAsyncResponseConsumer, (String)"HTTP response consumer");
        Args.notNull(connPool, (String)"HTTP connection pool");
        Args.notNull(e, (String)"Pool entry");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        BasicFuture<T> basicFuture = new BasicFuture<T>(futureCallback);
        NHttpClientConnection nHttpClientConnection = e.getConnection();
        BasicAsyncClientExchangeHandler<T> basicAsyncClientExchangeHandler = new BasicAsyncClientExchangeHandler<T>(httpAsyncRequestProducer, httpAsyncResponseConsumer, new RequestExecutionCallback(this, basicFuture, e, connPool), httpContext, nHttpClientConnection, this.httpprocessor, this.connReuseStrategy);
        this.initExecution(basicAsyncClientExchangeHandler, nHttpClientConnection);
        return basicFuture;
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<List<T>> executePipelined(List<HttpAsyncRequestProducer> list, List<HttpAsyncResponseConsumer<T>> list2, E e, ConnPool<HttpHost, E> connPool, HttpContext httpContext, FutureCallback<List<T>> futureCallback) {
        Args.notEmpty(list, (String)"Request producer list");
        Args.notEmpty(list2, (String)"Response consumer list");
        Args.notNull(connPool, (String)"HTTP connection pool");
        Args.notNull(e, (String)"Pool entry");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        BasicFuture<List<T>> basicFuture = new BasicFuture<List<T>>(futureCallback);
        NHttpClientConnection nHttpClientConnection = e.getConnection();
        PipeliningClientExchangeHandler<T> pipeliningClientExchangeHandler = new PipeliningClientExchangeHandler<T>(list, list2, new RequestExecutionCallback(this, basicFuture, e, connPool), httpContext, nHttpClientConnection, this.httpprocessor, this.connReuseStrategy);
        this.initExecution(pipeliningClientExchangeHandler, nHttpClientConnection);
        return basicFuture;
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, ConnPool<HttpHost, E> connPool, HttpContext httpContext) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, connPool, httpContext, null);
    }

    public <T, E extends PoolEntry<HttpHost, NHttpClientConnection>> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, ConnPool<HttpHost, E> connPool) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, connPool, (HttpContext)new BasicHttpContext());
    }

    protected void log(Exception exception) {
        this.exceptionLogger.log(exception);
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
    }

    static class RequestExecutionCallback<T, E extends PoolEntry<HttpHost, NHttpClientConnection>>
    implements FutureCallback<T> {
        private final BasicFuture<T> future;
        private final E poolEntry;
        private final ConnPool<HttpHost, E> connPool;
        final /* synthetic */ HttpAsyncRequester this$0;

        RequestExecutionCallback(BasicFuture<T> basicFuture, E e, ConnPool<HttpHost, E> connPool) {
            this.this$0 = var1_1;
            this.future = basicFuture;
            this.poolEntry = e;
            this.connPool = connPool;
        }

        @Override
        public void completed(T t) {
            try {
                this.connPool.release(this.poolEntry, true);
            }
            finally {
                this.future.completed(t);
            }
        }

        @Override
        public void failed(Exception exception) {
            try {
                this.connPool.release(this.poolEntry, false);
            }
            finally {
                this.future.failed(exception);
            }
        }

        @Override
        public void cancelled() {
            try {
                this.connPool.release(this.poolEntry, false);
            }
            finally {
                this.future.cancel(true);
            }
        }
    }

    class ConnPipelinedRequestCallback<T, E extends PoolEntry<HttpHost, NHttpClientConnection>>
    implements FutureCallback<E> {
        private final BasicFuture<List<T>> requestFuture;
        private final List<? extends HttpAsyncRequestProducer> requestProducers;
        private final List<? extends HttpAsyncResponseConsumer<T>> responseConsumers;
        private final ConnPool<HttpHost, E> connPool;
        private final HttpContext context;

        ConnPipelinedRequestCallback(BasicFuture<List<T>> basicFuture, List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, ConnPool<HttpHost, E> connPool, HttpContext httpContext) {
            this.requestFuture = basicFuture;
            this.requestProducers = list;
            this.responseConsumers = list2;
            this.connPool = connPool;
            this.context = httpContext;
        }

        @Override
        public void completed(E e) {
            if (this.requestFuture.isDone()) {
                this.connPool.release(e, true);
                return;
            }
            NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)((PoolEntry)e).getConnection();
            PipeliningClientExchangeHandler pipeliningClientExchangeHandler = new PipeliningClientExchangeHandler(this.requestProducers, this.responseConsumers, new RequestExecutionCallback(HttpAsyncRequester.this, this.requestFuture, e, this.connPool), this.context, nHttpClientConnection, HttpAsyncRequester.this.httpprocessor, HttpAsyncRequester.this.connReuseStrategy);
            HttpAsyncRequester.this.initExecution(pipeliningClientExchangeHandler, nHttpClientConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Exception exception) {
            try {
                try {
                    for (HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer : this.responseConsumers) {
                        httpAsyncResponseConsumer.failed(exception);
                    }
                }
                finally {
                    this.releaseResources();
                }
            }
            finally {
                this.requestFuture.failed(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelled() {
            try {
                try {
                    for (HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer : this.responseConsumers) {
                        httpAsyncResponseConsumer.cancel();
                    }
                }
                finally {
                    this.releaseResources();
                }
            }
            finally {
                this.requestFuture.cancel(true);
            }
        }

        public void releaseResources() {
            for (HttpAsyncRequestProducer closeable : this.requestProducers) {
                HttpAsyncRequester.this.close(closeable);
            }
            for (HttpAsyncResponseConsumer httpAsyncResponseConsumer : this.responseConsumers) {
                HttpAsyncRequester.this.close(httpAsyncResponseConsumer);
            }
        }
    }

    class ConnRequestCallback<T, E extends PoolEntry<HttpHost, NHttpClientConnection>>
    implements FutureCallback<E> {
        private final BasicFuture<T> requestFuture;
        private final HttpAsyncRequestProducer requestProducer;
        private final HttpAsyncResponseConsumer<T> responseConsumer;
        private final ConnPool<HttpHost, E> connPool;
        private final HttpContext context;

        ConnRequestCallback(BasicFuture<T> basicFuture, HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, ConnPool<HttpHost, E> connPool, HttpContext httpContext) {
            this.requestFuture = basicFuture;
            this.requestProducer = httpAsyncRequestProducer;
            this.responseConsumer = httpAsyncResponseConsumer;
            this.connPool = connPool;
            this.context = httpContext;
        }

        @Override
        public void completed(E e) {
            if (this.requestFuture.isDone()) {
                this.connPool.release(e, true);
                return;
            }
            NHttpClientConnection nHttpClientConnection = (NHttpClientConnection)((PoolEntry)e).getConnection();
            BasicAsyncClientExchangeHandler<T> basicAsyncClientExchangeHandler = new BasicAsyncClientExchangeHandler<T>(this.requestProducer, this.responseConsumer, new RequestExecutionCallback(HttpAsyncRequester.this, this.requestFuture, e, this.connPool), this.context, nHttpClientConnection, HttpAsyncRequester.this.httpprocessor, HttpAsyncRequester.this.connReuseStrategy);
            HttpAsyncRequester.this.initExecution(basicAsyncClientExchangeHandler, nHttpClientConnection);
        }

        @Override
        public void failed(Exception exception) {
            try {
                try {
                    this.responseConsumer.failed(exception);
                }
                finally {
                    this.releaseResources();
                }
            }
            finally {
                this.requestFuture.failed(exception);
            }
        }

        @Override
        public void cancelled() {
            try {
                try {
                    this.responseConsumer.cancel();
                }
                finally {
                    this.releaseResources();
                }
            }
            finally {
                this.requestFuture.cancel(true);
            }
        }

        public void releaseResources() {
            HttpAsyncRequester.this.close(this.requestProducer);
            HttpAsyncRequester.this.close(this.responseConsumer);
        }
    }
}

