/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.MethodNotSupportedException;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.UnsupportedHttpVersionException;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.concurrent.Cancellable;
import com.icbc.api.internal.apache.http.entity.ContentType;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.NHttpConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServerConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServerEventHandler;
import com.icbc.api.internal.apache.http.nio.entity.NStringEntity;
import com.icbc.api.internal.apache.http.nio.protocol.BasicAsyncResponseProducer;
import com.icbc.api.internal.apache.http.nio.protocol.ErrorResponseProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncExchange;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncExpectationVerifier;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseProducer;
import com.icbc.api.internal.apache.http.nio.protocol.MessageState;
import com.icbc.api.internal.apache.http.nio.protocol.NullRequestHandler;
import com.icbc.api.internal.apache.http.nio.reactor.SessionBufferStatus;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpAsyncService
implements NHttpServerEventHandler {
    static final String HTTP_EXCHANGE_STATE = "http.nio.http-exchange-state";
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpResponseFactory responseFactory;
    private final HttpAsyncRequestHandlerMapper handlerMapper;
    private final HttpAsyncExpectationVerifier expectationVerifier;
    private final ExceptionLogger exceptionLogger;

    @Deprecated
    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory, HttpAsyncRequestHandlerResolver httpAsyncRequestHandlerResolver, HttpAsyncExpectationVerifier httpAsyncExpectationVerifier, HttpParams httpParams) {
        this(httpProcessor, connectionReuseStrategy, httpResponseFactory, new HttpAsyncRequestHandlerResolverAdapter(httpAsyncRequestHandlerResolver), httpAsyncExpectationVerifier);
    }

    @Deprecated
    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpAsyncRequestHandlerResolver httpAsyncRequestHandlerResolver, HttpParams httpParams) {
        this(httpProcessor, connectionReuseStrategy, DefaultHttpResponseFactory.INSTANCE, new HttpAsyncRequestHandlerResolverAdapter(httpAsyncRequestHandlerResolver), null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory, HttpAsyncRequestHandlerMapper httpAsyncRequestHandlerMapper, HttpAsyncExpectationVerifier httpAsyncExpectationVerifier) {
        this(httpProcessor, connectionReuseStrategy, httpResponseFactory, httpAsyncRequestHandlerMapper, httpAsyncExpectationVerifier, null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, HttpResponseFactory httpResponseFactory, HttpAsyncRequestHandlerMapper httpAsyncRequestHandlerMapper, HttpAsyncExpectationVerifier httpAsyncExpectationVerifier, ExceptionLogger exceptionLogger) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.connStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseFactory = httpResponseFactory != null ? httpResponseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.handlerMapper = httpAsyncRequestHandlerMapper;
        this.expectationVerifier = httpAsyncExpectationVerifier;
        this.exceptionLogger = exceptionLogger != null ? exceptionLogger : ExceptionLogger.NO_OP;
    }

    public HttpAsyncService(HttpProcessor httpProcessor, HttpAsyncRequestHandlerMapper httpAsyncRequestHandlerMapper) {
        this(httpProcessor, null, null, httpAsyncRequestHandlerMapper, null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, HttpAsyncRequestHandlerMapper httpAsyncRequestHandlerMapper, ExceptionLogger exceptionLogger) {
        this(httpProcessor, null, null, httpAsyncRequestHandlerMapper, null, exceptionLogger);
    }

    @Override
    public void connected(NHttpServerConnection nHttpServerConnection) {
        State state = new State();
        nHttpServerConnection.getContext().setAttribute(HTTP_EXCHANGE_STATE, state);
    }

    @Override
    public void closed(NHttpServerConnection nHttpServerConnection) {
        State state = (State)nHttpServerConnection.getContext().removeAttribute(HTTP_EXCHANGE_STATE);
        if (state != null) {
            state.setTerminated();
            this.closeHandlers(state);
            Cancellable cancellable = state.getCancellable();
            if (cancellable != null) {
                cancellable.cancel();
            }
        }
    }

    @Override
    public void exception(NHttpServerConnection nHttpServerConnection, Exception exception) {
        Queue<PipelineEntry> queue;
        State state = this.getState(nHttpServerConnection);
        if (state == null) {
            this.shutdownConnection(nHttpServerConnection);
            this.log(exception);
            return;
        }
        state.setTerminated();
        this.closeHandlers(state, exception);
        Cancellable cancellable = state.getCancellable();
        if (cancellable != null) {
            cancellable.cancel();
        }
        if (!(queue = state.getPipeline()).isEmpty() || nHttpServerConnection.isResponseSubmitted() || state.getResponseState().compareTo((Enum)MessageState.INIT) > 0) {
            this.shutdownConnection(nHttpServerConnection);
        } else {
            try {
                Incoming incoming = state.getIncoming();
                HttpRequest httpRequest = incoming != null ? incoming.getRequest() : null;
                HttpContext httpContext = incoming != null ? incoming.getContext() : new BasicHttpContext();
                HttpAsyncResponseProducer httpAsyncResponseProducer = this.handleException(exception, httpContext);
                HttpResponse httpResponse = httpAsyncResponseProducer.generateResponse();
                Outgoing outgoing = new Outgoing(httpRequest, httpResponse, httpAsyncResponseProducer, httpContext);
                state.setResponseState(MessageState.INIT);
                state.setOutgoing(outgoing);
                this.commitFinalResponse(nHttpServerConnection, state);
            }
            catch (Exception exception2) {
                this.shutdownConnection(nHttpServerConnection);
                this.closeHandlers(state);
                if (exception2 instanceof RuntimeException) {
                    throw (RuntimeException)exception2;
                }
                this.log(exception2);
            }
        }
    }

    @Override
    public void requestReceived(NHttpServerConnection nHttpServerConnection) throws IOException, HttpException {
        State state = this.getState(nHttpServerConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.READY ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        HttpRequest httpRequest = nHttpServerConnection.getHttpRequest();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        basicHttpContext.setAttribute("http.request", httpRequest);
        basicHttpContext.setAttribute("http.connection", nHttpServerConnection);
        this.httpProcessor.process(httpRequest, (HttpContext)basicHttpContext);
        HttpAsyncRequestHandler<Object> httpAsyncRequestHandler = this.getRequestHandler(httpRequest);
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer = httpAsyncRequestHandler.processRequest(httpRequest, basicHttpContext);
        httpAsyncRequestConsumer.requestReceived(httpRequest);
        Incoming incoming = new Incoming(httpRequest, httpAsyncRequestHandler, httpAsyncRequestConsumer, basicHttpContext);
        state.setIncoming(incoming);
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)httpRequest).expectContinue() && state.getResponseState() == MessageState.READY && state.getPipeline().isEmpty() && (!(nHttpServerConnection instanceof SessionBufferStatus) || !((SessionBufferStatus)((Object)nHttpServerConnection)).hasBufferedInput())) {
                state.setRequestState(MessageState.ACK_EXPECTED);
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 100, basicHttpContext);
                if (this.expectationVerifier != null) {
                    nHttpServerConnection.suspendInput();
                    nHttpServerConnection.suspendOutput();
                    HttpAsyncExchangeImpl httpAsyncExchangeImpl = new HttpAsyncExchangeImpl(httpRequest, httpResponse, state, nHttpServerConnection, basicHttpContext);
                    this.expectationVerifier.verify(httpAsyncExchangeImpl, basicHttpContext);
                } else {
                    nHttpServerConnection.submitResponse(httpResponse);
                    state.setRequestState(MessageState.BODY_STREAM);
                }
            } else {
                state.setRequestState(MessageState.BODY_STREAM);
            }
        } else {
            this.completeRequest(incoming, nHttpServerConnection, state);
        }
    }

    @Override
    public void inputReady(NHttpServerConnection nHttpServerConnection, ContentDecoder contentDecoder) throws IOException, HttpException {
        State state = this.getState(nHttpServerConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.BODY_STREAM ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        Incoming incoming = state.getIncoming();
        Asserts.notNull((Object)incoming, (String)"Incoming request");
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer = incoming.getConsumer();
        httpAsyncRequestConsumer.consumeContent(contentDecoder, nHttpServerConnection);
        if (contentDecoder.isCompleted()) {
            this.completeRequest(incoming, nHttpServerConnection, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void responseReady(NHttpServerConnection nHttpServerConnection) throws IOException, HttpException {
        Object object;
        Queue<PipelineEntry> queue;
        State state = this.getState(nHttpServerConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.READY || state.getResponseState() == MessageState.INIT ? 1 : 0) != 0, (String)"Unexpected response state %s", (Object)state.getResponseState());
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            Outgoing outgoing = state.getOutgoing();
            Asserts.notNull((Object)outgoing, (String)"Outgoing response");
            HttpResponse httpResponse = outgoing.getResponse();
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n == 100) {
                HttpContext httpContext = outgoing.getContext();
                try (HttpAsyncResponseProducer httpAsyncResponseProducer = outgoing.getProducer();){
                    httpResponse.setEntity(null);
                    nHttpServerConnection.requestInput();
                    state.setRequestState(MessageState.BODY_STREAM);
                    state.setOutgoing(null);
                    nHttpServerConnection.submitResponse(httpResponse);
                    httpAsyncResponseProducer.responseCompleted(httpContext);
                    return;
                }
            } else {
                if (n < 400) throw new HttpException("Invalid response: " + httpResponse.getStatusLine());
                nHttpServerConnection.resetInput();
                state.setRequestState(MessageState.READY);
                this.commitFinalResponse(nHttpServerConnection, state);
            }
            return;
        }
        if (state.getResponseState() == MessageState.READY) {
            queue = state.getPipeline();
            object = queue.poll();
            if (object == null) {
                nHttpServerConnection.suspendOutput();
                return;
            }
            state.setResponseState(MessageState.INIT);
            Object object2 = ((PipelineEntry)object).getResult();
            HttpRequest httpRequest = ((PipelineEntry)object).getRequest();
            HttpContext httpContext = ((PipelineEntry)object).getContext();
            if (object2 != null) {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, 200, httpContext);
                HttpAsyncExchangeImpl httpAsyncExchangeImpl = new HttpAsyncExchangeImpl(httpRequest, httpResponse, state, nHttpServerConnection, httpContext);
                HttpAsyncRequestHandler<Object> httpAsyncRequestHandler = ((PipelineEntry)object).getHandler();
                nHttpServerConnection.suspendOutput();
                try {
                    httpAsyncRequestHandler.handle(object2, httpAsyncExchangeImpl, httpContext);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    queue.add(new PipelineEntry(httpRequest, null, exception, httpAsyncRequestHandler, httpContext));
                    state.setResponseState(MessageState.READY);
                    this.responseReady(nHttpServerConnection);
                    return;
                }
            } else {
                Exception exception = ((PipelineEntry)object).getException();
                HttpAsyncResponseProducer httpAsyncResponseProducer = this.handleException(exception != null ? exception : new HttpException("Internal error processing request"), httpContext);
                HttpResponse httpResponse = httpAsyncResponseProducer.generateResponse();
                state.setOutgoing(new Outgoing(httpRequest, httpResponse, httpAsyncResponseProducer, httpContext));
            }
        }
        if (state.getResponseState() != MessageState.INIT) return;
        object = state;
        synchronized (object) {
            queue = state.getOutgoing();
            if (queue == null) {
                nHttpServerConnection.suspendOutput();
                return;
            }
        }
        object = ((Outgoing)((Object)queue)).getResponse();
        int n = object.getStatusLine().getStatusCode();
        if (n < 200) throw new HttpException("Invalid response: " + object.getStatusLine());
        this.commitFinalResponse(nHttpServerConnection, state);
    }

    @Override
    public void outputReady(NHttpServerConnection nHttpServerConnection, ContentEncoder contentEncoder) throws HttpException, IOException {
        State state = this.getState(nHttpServerConnection);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.BODY_STREAM ? 1 : 0) != 0, (String)"Unexpected response state %s", (Object)state.getResponseState());
        Outgoing outgoing = state.getOutgoing();
        Asserts.notNull((Object)outgoing, (String)"Outgoing response");
        HttpAsyncResponseProducer httpAsyncResponseProducer = outgoing.getProducer();
        httpAsyncResponseProducer.produceContent(contentEncoder, nHttpServerConnection);
        if (contentEncoder.isCompleted()) {
            this.completeResponse(outgoing, nHttpServerConnection, state);
        }
    }

    @Override
    public void endOfInput(NHttpServerConnection nHttpServerConnection) throws IOException {
        if (nHttpServerConnection.getSocketTimeout() <= 0) {
            nHttpServerConnection.setSocketTimeout(1000);
        }
        nHttpServerConnection.close();
    }

    @Override
    public void timeout(NHttpServerConnection nHttpServerConnection) throws IOException {
        State state = this.getState(nHttpServerConnection);
        if (state != null) {
            this.closeHandlers(state, new SocketTimeoutException());
        }
        if (nHttpServerConnection.getStatus() == 0) {
            nHttpServerConnection.close();
            if (nHttpServerConnection.getStatus() == 1) {
                nHttpServerConnection.setSocketTimeout(250);
            }
        } else {
            nHttpServerConnection.shutdown();
        }
    }

    private State getState(NHttpConnection nHttpConnection) {
        return (State)nHttpConnection.getContext().getAttribute(HTTP_EXCHANGE_STATE);
    }

    protected void log(Exception exception) {
        this.exceptionLogger.log(exception);
    }

    private void shutdownConnection(NHttpConnection nHttpConnection) {
        try {
            nHttpConnection.shutdown();
        }
        catch (IOException iOException) {
            this.log(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHandlers(State state, Exception exception) {
        HttpAsyncResponseProducer httpAsyncResponseProducer;
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer;
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer2 = httpAsyncRequestConsumer = state.getIncoming() != null ? state.getIncoming().getConsumer() : null;
        if (httpAsyncRequestConsumer != null) {
            try {
                httpAsyncRequestConsumer.failed(exception);
            }
            finally {
                try {
                    httpAsyncRequestConsumer.close();
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
        }
        HttpAsyncResponseProducer httpAsyncResponseProducer2 = httpAsyncResponseProducer = state.getOutgoing() != null ? state.getOutgoing().getProducer() : null;
        if (httpAsyncResponseProducer != null) {
            try {
                httpAsyncResponseProducer.failed(exception);
            }
            finally {
                try {
                    httpAsyncResponseProducer.close();
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
        }
    }

    private void closeHandlers(State state) {
        HttpAsyncResponseProducer httpAsyncResponseProducer;
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer;
        HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer2 = httpAsyncRequestConsumer = state.getIncoming() != null ? state.getIncoming().getConsumer() : null;
        if (httpAsyncRequestConsumer != null) {
            try {
                httpAsyncRequestConsumer.close();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
        HttpAsyncResponseProducer httpAsyncResponseProducer2 = httpAsyncResponseProducer = state.getOutgoing() != null ? state.getOutgoing().getProducer() : null;
        if (httpAsyncResponseProducer != null) {
            try {
                httpAsyncResponseProducer.close();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
    }

    protected HttpAsyncResponseProducer handleException(Exception exception, HttpContext httpContext) {
        int n = exception instanceof MethodNotSupportedException ? 501 : (exception instanceof UnsupportedHttpVersionException ? 505 : (exception instanceof ProtocolException ? 400 : 500));
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        HttpResponse httpResponse = this.responseFactory.newHttpResponse(HttpVersion.HTTP_1_1, n, httpContext);
        return new ErrorResponseProducer(httpResponse, new NStringEntity(string, ContentType.DEFAULT_TEXT), false);
    }

    protected void handleAlreadySubmittedResponse(Cancellable cancellable, HttpContext httpContext) {
        throw new IllegalStateException("Response already submitted");
    }

    protected void handleAlreadySubmittedResponse(HttpAsyncResponseProducer httpAsyncResponseProducer, HttpContext httpContext) {
        throw new IllegalStateException("Response already submitted");
    }

    private boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && "HEAD".equalsIgnoreCase(httpRequest.getRequestLine().getMethod())) {
            return false;
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        return n >= 200 && n != 204 && n != 304 && n != 205;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRequest(Incoming incoming, NHttpServerConnection nHttpServerConnection, State state) throws IOException, HttpException {
        PipelineEntry pipelineEntry;
        Object object;
        state.setRequestState(MessageState.READY);
        state.setIncoming(null);
        try (HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer = incoming.getConsumer();){
            object = incoming.getContext();
            httpAsyncRequestConsumer.requestCompleted((HttpContext)object);
            pipelineEntry = new PipelineEntry(incoming.getRequest(), httpAsyncRequestConsumer.getResult(), httpAsyncRequestConsumer.getException(), incoming.getHandler(), (HttpContext)object);
        }
        object = state.getPipeline();
        object.add(pipelineEntry);
        if (state.getResponseState() == MessageState.READY) {
            nHttpServerConnection.requestOutput();
        }
    }

    private void commitFinalResponse(NHttpServerConnection nHttpServerConnection, State state) throws IOException, HttpException {
        Outgoing outgoing = state.getOutgoing();
        Asserts.notNull((Object)outgoing, (String)"Outgoing response");
        HttpRequest httpRequest = outgoing.getRequest();
        HttpResponse httpResponse = outgoing.getResponse();
        HttpContext httpContext = outgoing.getContext();
        httpContext.setAttribute("http.response", httpResponse);
        this.httpProcessor.process(httpResponse, httpContext);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null && !this.canResponseHaveBody(httpRequest, httpResponse)) {
            httpResponse.setEntity(null);
            httpEntity = null;
        }
        nHttpServerConnection.submitResponse(httpResponse);
        if (httpEntity == null) {
            this.completeResponse(outgoing, nHttpServerConnection, state);
        } else {
            state.setResponseState(MessageState.BODY_STREAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeResponse(Outgoing outgoing, NHttpServerConnection nHttpServerConnection, State state) throws IOException, HttpException {
        HttpContext httpContext = outgoing.getContext();
        HttpResponse httpResponse = outgoing.getResponse();
        try (HttpAsyncResponseProducer httpAsyncResponseProducer = outgoing.getProducer();){
            httpAsyncResponseProducer.responseCompleted(httpContext);
            state.setOutgoing(null);
            state.setCancellable(null);
            state.setResponseState(MessageState.READY);
        }
        if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
            nHttpServerConnection.close();
        } else {
            nHttpServerConnection.requestInput();
        }
    }

    private HttpAsyncRequestHandler<Object> getRequestHandler(HttpRequest httpRequest) {
        NullRequestHandler nullRequestHandler = null;
        if (this.handlerMapper != null) {
            nullRequestHandler = this.handlerMapper.lookup(httpRequest);
        }
        if (nullRequestHandler == null) {
            nullRequestHandler = new NullRequestHandler();
        }
        return nullRequestHandler;
    }

    @Deprecated
    private static class HttpAsyncRequestHandlerResolverAdapter
    implements HttpAsyncRequestHandlerMapper {
        private final HttpAsyncRequestHandlerResolver resolver;

        public HttpAsyncRequestHandlerResolverAdapter(HttpAsyncRequestHandlerResolver httpAsyncRequestHandlerResolver) {
            this.resolver = httpAsyncRequestHandlerResolver;
        }

        @Override
        public HttpAsyncRequestHandler<?> lookup(HttpRequest httpRequest) {
            return this.resolver.lookup(httpRequest.getRequestLine().getUri());
        }
    }

    class HttpAsyncExchangeImpl
    implements HttpAsyncExchange {
        private final AtomicBoolean completed = new AtomicBoolean();
        private final HttpRequest request;
        private final HttpResponse response;
        private final State state;
        private final NHttpServerConnection conn;
        private final HttpContext context;

        public HttpAsyncExchangeImpl(HttpRequest httpRequest, HttpResponse httpResponse, State state, NHttpServerConnection nHttpServerConnection, HttpContext httpContext) {
            this.request = httpRequest;
            this.response = httpResponse;
            this.state = state;
            this.conn = nHttpServerConnection;
            this.context = httpContext;
        }

        @Override
        public HttpRequest getRequest() {
            return this.request;
        }

        @Override
        public HttpResponse getResponse() {
            return this.response;
        }

        @Override
        public void setCallback(Cancellable cancellable) {
            if (this.completed.get()) {
                HttpAsyncService.this.handleAlreadySubmittedResponse(cancellable, this.context);
            } else if (this.state.isTerminated() && cancellable != null) {
                cancellable.cancel();
            } else {
                this.state.setCancellable(cancellable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submitResponse(HttpAsyncResponseProducer httpAsyncResponseProducer) {
            Args.notNull((Object)httpAsyncResponseProducer, (String)"Response producer");
            if (this.completed.getAndSet(true)) {
                HttpAsyncService.this.handleAlreadySubmittedResponse(httpAsyncResponseProducer, this.context);
            } else {
                if (!this.state.isTerminated()) {
                    HttpResponse httpResponse = httpAsyncResponseProducer.generateResponse();
                    Outgoing outgoing = new Outgoing(this.request, httpResponse, httpAsyncResponseProducer, this.context);
                    State state = this.state;
                    synchronized (state) {
                        this.state.setOutgoing(outgoing);
                        this.state.setCancellable(null);
                        this.conn.requestOutput();
                    }
                }
                try {
                    httpAsyncResponseProducer.close();
                }
                catch (IOException iOException) {
                    HttpAsyncService.this.log(iOException);
                }
            }
        }

        @Override
        public void submitResponse() {
            this.submitResponse(new BasicAsyncResponseProducer(this.response));
        }

        @Override
        public boolean isCompleted() {
            return this.completed.get();
        }

        @Override
        public void setTimeout(int n) {
            this.conn.setSocketTimeout(n);
        }

        @Override
        public int getTimeout() {
            return this.conn.getSocketTimeout();
        }
    }

    static class State {
        private final Queue<PipelineEntry> pipeline = new ConcurrentLinkedQueue<PipelineEntry>();
        private volatile boolean terminated;
        private volatile MessageState requestState = MessageState.READY;
        private volatile MessageState responseState = MessageState.READY;
        private volatile Incoming incoming;
        private volatile Outgoing outgoing;
        private volatile Cancellable cancellable;

        State() {
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void setTerminated() {
            this.terminated = true;
        }

        public MessageState getRequestState() {
            return this.requestState;
        }

        public void setRequestState(MessageState messageState) {
            this.requestState = messageState;
        }

        public MessageState getResponseState() {
            return this.responseState;
        }

        public void setResponseState(MessageState messageState) {
            this.responseState = messageState;
        }

        public Incoming getIncoming() {
            return this.incoming;
        }

        public void setIncoming(Incoming incoming) {
            this.incoming = incoming;
        }

        public Outgoing getOutgoing() {
            return this.outgoing;
        }

        public void setOutgoing(Outgoing outgoing) {
            this.outgoing = outgoing;
        }

        public Cancellable getCancellable() {
            return this.cancellable;
        }

        public void setCancellable(Cancellable cancellable) {
            this.cancellable = cancellable;
        }

        public Queue<PipelineEntry> getPipeline() {
            return this.pipeline;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[incoming ");
            stringBuilder.append(this.requestState);
            if (this.incoming != null) {
                stringBuilder.append(" ");
                stringBuilder.append(this.incoming.getRequest().getRequestLine());
            }
            stringBuilder.append("; outgoing ");
            stringBuilder.append(this.responseState);
            if (this.outgoing != null) {
                stringBuilder.append(" ");
                stringBuilder.append(this.outgoing.getResponse().getStatusLine());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    static class PipelineEntry {
        private final HttpRequest request;
        private final Object result;
        private final Exception exception;
        private final HttpAsyncRequestHandler<Object> handler;
        private final HttpContext context;

        PipelineEntry(HttpRequest httpRequest, Object object, Exception exception, HttpAsyncRequestHandler<Object> httpAsyncRequestHandler, HttpContext httpContext) {
            this.request = httpRequest;
            this.result = object;
            this.exception = exception;
            this.handler = httpAsyncRequestHandler;
            this.context = httpContext;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public Object getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }

        public HttpAsyncRequestHandler<Object> getHandler() {
            return this.handler;
        }

        public HttpContext getContext() {
            return this.context;
        }
    }

    static class Outgoing {
        private final HttpRequest request;
        private final HttpResponse response;
        private final HttpAsyncResponseProducer producer;
        private final HttpContext context;

        Outgoing(HttpRequest httpRequest, HttpResponse httpResponse, HttpAsyncResponseProducer httpAsyncResponseProducer, HttpContext httpContext) {
            this.request = httpRequest;
            this.response = httpResponse;
            this.producer = httpAsyncResponseProducer;
            this.context = httpContext;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public HttpAsyncResponseProducer getProducer() {
            return this.producer;
        }

        public HttpContext getContext() {
            return this.context;
        }
    }

    static class Incoming {
        private final HttpRequest request;
        private final HttpAsyncRequestHandler<Object> handler;
        private final HttpAsyncRequestConsumer<Object> consumer;
        private final HttpContext context;

        Incoming(HttpRequest httpRequest, HttpAsyncRequestHandler<Object> httpAsyncRequestHandler, HttpAsyncRequestConsumer<Object> httpAsyncRequestConsumer, HttpContext httpContext) {
            this.request = httpRequest;
            this.handler = httpAsyncRequestHandler;
            this.consumer = httpAsyncRequestConsumer;
            this.context = httpContext;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpAsyncRequestHandler<Object> getHandler() {
            return this.handler;
        }

        public HttpAsyncRequestConsumer<Object> getConsumer() {
            return this.consumer;
        }

        public HttpContext getContext() {
            return this.context;
        }
    }
}

