/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.nio.NHttpConnection;
import com.icbc.api.internal.apache.http.nio.protocol.EventListener;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;

@Deprecated
public abstract class NHttpHandlerBase {
    protected static final String CONN_STATE = "http.nio.conn-state";
    protected final HttpProcessor httpProcessor;
    protected final ConnectionReuseStrategy connStrategy;
    protected final ByteBufferAllocator allocator;
    protected final HttpParams params;
    protected EventListener eventListener;

    public NHttpHandlerBase(HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        Args.notNull((Object)connectionReuseStrategy, (String)"Connection reuse strategy");
        Args.notNull((Object)byteBufferAllocator, (String)"ByteBuffer allocator");
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        this.httpProcessor = httpProcessor;
        this.connStrategy = connectionReuseStrategy;
        this.allocator = byteBufferAllocator;
        this.params = httpParams;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    protected void closeConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        try {
            nHttpConnection.close();
        }
        catch (IOException iOException) {
            try {
                nHttpConnection.shutdown();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
    }

    protected void shutdownConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        try {
            nHttpConnection.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleTimeout(NHttpConnection nHttpConnection) {
        try {
            if (nHttpConnection.getStatus() == 0) {
                nHttpConnection.close();
                if (nHttpConnection.getStatus() == 1) {
                    nHttpConnection.setSocketTimeout(250);
                }
                if (this.eventListener != null) {
                    this.eventListener.connectionTimeout(nHttpConnection);
                }
            } else {
                nHttpConnection.shutdown();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && "HEAD".equalsIgnoreCase(httpRequest.getRequestLine().getMethod())) {
            return false;
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        return n >= 200 && n != 204 && n != 304 && n != 205;
    }
}

