/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.protocol;

import com.icbc.api.internal.apache.http.ConnectionClosedException;
import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.IOControl;
import com.icbc.api.internal.apache.http.nio.NHttpClientConnection;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.protocol.Pipelined;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Pipelined
public class PipeliningClientExchangeHandler<T>
implements HttpAsyncClientExchangeHandler {
    private final Queue<HttpAsyncRequestProducer> requestProducerQueue;
    private final Queue<HttpAsyncResponseConsumer<T>> responseConsumerQueue;
    private final Queue<HttpRequest> requestQueue;
    private final Queue<T> resultQueue;
    private final BasicFuture<List<T>> future;
    private final HttpContext localContext;
    private final NHttpClientConnection conn;
    private final HttpProcessor httppocessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final AtomicReference<HttpAsyncRequestProducer> requestProducerRef;
    private final AtomicReference<HttpAsyncResponseConsumer<T>> responseConsumerRef;
    private final AtomicBoolean keepAlive;
    private final AtomicBoolean closed;

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, FutureCallback<List<T>> futureCallback, HttpContext httpContext, NHttpClientConnection nHttpClientConnection, HttpProcessor httpProcessor, ConnectionReuseStrategy connectionReuseStrategy) {
        Args.notEmpty(list, (String)"Request producer list");
        Args.notEmpty(list2, (String)"Response consumer list");
        Args.check((list.size() == list2.size() ? 1 : 0) != 0, (String)"Number of request producers does not match that of response consumers");
        this.requestProducerQueue = new ConcurrentLinkedQueue<HttpAsyncRequestProducer>(list);
        this.responseConsumerQueue = new ConcurrentLinkedQueue<HttpAsyncResponseConsumer<T>>(list2);
        this.requestQueue = new ConcurrentLinkedQueue<HttpRequest>();
        this.resultQueue = new ConcurrentLinkedQueue<T>();
        this.future = new BasicFuture<List<List<T>>>(futureCallback);
        this.localContext = (HttpContext)Args.notNull((Object)httpContext, (String)"HTTP context");
        this.conn = (NHttpClientConnection)Args.notNull((Object)nHttpClientConnection, (String)"HTTP connection");
        this.httppocessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.connReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.localContext.setAttribute("http.connection", this.conn);
        this.requestProducerRef = new AtomicReference<Object>(null);
        this.responseConsumerRef = new AtomicReference<Object>(null);
        this.keepAlive = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> list, List<? extends HttpAsyncResponseConsumer<T>> list2, HttpContext httpContext, NHttpClientConnection nHttpClientConnection, HttpProcessor httpProcessor) {
        this(list, list2, null, httpContext, nHttpClientConnection, httpProcessor, null);
    }

    public Future<List<T>> getFuture() {
        return this.future;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void releaseResources() {
        PipeliningClientExchangeHandler.closeQuietly(this.requestProducerRef.getAndSet(null));
        PipeliningClientExchangeHandler.closeQuietly(this.responseConsumerRef.getAndSet(null));
        while (!this.requestProducerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly(this.requestProducerQueue.remove());
        }
        while (!this.responseConsumerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly(this.responseConsumerQueue.remove());
        }
        this.requestQueue.clear();
        this.resultQueue.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.releaseResources();
            if (!this.future.isDone()) {
                this.future.cancel();
            }
        }
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        Asserts.check((this.requestProducerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is not null");
        HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerQueue.poll();
        if (httpAsyncRequestProducer == null) {
            return null;
        }
        this.requestProducerRef.set(httpAsyncRequestProducer);
        HttpRequest httpRequest = httpAsyncRequestProducer.generateRequest();
        this.httppocessor.process(httpRequest, this.localContext);
        this.requestQueue.add(httpRequest);
        return httpRequest;
    }

    @Override
    public void produceContent(ContentEncoder contentEncoder, IOControl iOControl) throws IOException {
        HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerRef.get();
        Asserts.check((httpAsyncRequestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        httpAsyncRequestProducer.produceContent(contentEncoder, iOControl);
    }

    @Override
    public void requestCompleted() {
        HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerRef.getAndSet(null);
        Asserts.check((httpAsyncRequestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        httpAsyncRequestProducer.requestCompleted(this.localContext);
    }

    @Override
    public void responseReceived(HttpResponse httpResponse) throws IOException, HttpException {
        Asserts.check((this.responseConsumerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is not null");
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer = this.responseConsumerQueue.poll();
        Asserts.check((httpAsyncResponseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer queue is empty");
        this.responseConsumerRef.set(httpAsyncResponseConsumer);
        HttpRequest httpRequest = this.requestQueue.poll();
        Asserts.check((httpRequest != null ? 1 : 0) != 0, (String)"Inconsistent state: request queue is empty");
        this.localContext.setAttribute("http.request", httpRequest);
        this.localContext.setAttribute("http.response", httpResponse);
        this.httppocessor.process(httpResponse, this.localContext);
        httpAsyncResponseConsumer.responseReceived(httpResponse);
        this.keepAlive.set(this.connReuseStrategy.keepAlive(httpResponse, this.localContext));
    }

    @Override
    public void consumeContent(ContentDecoder contentDecoder, IOControl iOControl) throws IOException {
        HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer = this.responseConsumerRef.get();
        Asserts.check((httpAsyncResponseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        httpAsyncResponseConsumer.consumeContent(contentDecoder, iOControl);
    }

    @Override
    public void responseCompleted() throws IOException {
        HttpAsyncResponseConsumer httpAsyncResponseConsumer = this.responseConsumerRef.getAndSet(null);
        Asserts.check((httpAsyncResponseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        try {
            if (!this.keepAlive.get()) {
                this.conn.close();
            }
            httpAsyncResponseConsumer.responseCompleted(this.localContext);
            Object t = httpAsyncResponseConsumer.getResult();
            Exception exception = httpAsyncResponseConsumer.getException();
            if (t != null) {
                this.resultQueue.add(t);
            } else {
                this.future.failed(exception);
                this.conn.shutdown();
            }
            if (!this.conn.isOpen() && this.closed.compareAndSet(false, true)) {
                this.releaseResources();
            }
            if (!this.future.isDone() && this.responseConsumerQueue.isEmpty()) {
                this.future.completed(new ArrayList<T>(this.resultQueue));
                this.resultQueue.clear();
            }
        }
        catch (RuntimeException runtimeException) {
            this.failed(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void inputTerminated() {
        this.failed(new ConnectionClosedException("Connection closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception exception) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer;
                HttpAsyncRequestProducer httpAsyncRequestProducer = this.requestProducerRef.get();
                if (httpAsyncRequestProducer != null) {
                    httpAsyncRequestProducer.failed(exception);
                }
                if ((httpAsyncResponseConsumer = this.responseConsumerRef.get()) != null) {
                    httpAsyncResponseConsumer.failed(exception);
                }
            }
            finally {
                try {
                    this.future.failed(exception);
                }
                finally {
                    this.releaseResources();
                }
            }
        }
    }

    @Override
    public boolean cancel() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                boolean bl;
                try {
                    HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer = this.responseConsumerRef.get();
                    bl = httpAsyncResponseConsumer != null && httpAsyncResponseConsumer.cancel();
                    this.future.cancel();
                }
                catch (Throwable throwable) {
                    this.future.cancel();
                    throw throwable;
                }
                return bl;
            }
            finally {
                this.releaseResources();
            }
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }
}

