/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.nio.util.BufferInfo;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.util.Args;
import java.nio.ByteBuffer;

public class ExpandableBuffer
implements com.icbc.api.internal.apache.http.io.BufferInfo,
BufferInfo {
    public static final int INPUT_MODE = 0;
    public static final int OUTPUT_MODE = 1;
    private final ByteBufferAllocator allocator;
    private int mode;
    protected ByteBuffer buffer = null;

    public ExpandableBuffer(int n, ByteBufferAllocator byteBufferAllocator) {
        Args.notNull((Object)byteBufferAllocator, (String)"ByteBuffer allocator");
        this.allocator = byteBufferAllocator;
        this.buffer = byteBufferAllocator.allocate(n);
        this.mode = 0;
    }

    protected int getMode() {
        return this.mode;
    }

    protected void setOutputMode() {
        if (this.mode != 1) {
            this.buffer.flip();
            this.mode = 1;
        }
    }

    protected void setInputMode() {
        if (this.mode != 0) {
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.mode = 0;
        }
    }

    private void expandCapacity(int n) {
        ByteBuffer byteBuffer = this.buffer;
        this.buffer = this.allocator.allocate(n);
        byteBuffer.flip();
        this.buffer.put(byteBuffer);
    }

    protected void expand() {
        int n = this.buffer.capacity() + 1 << 1;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        this.expandCapacity(n);
    }

    protected void ensureCapacity(int n) {
        if (n > this.buffer.capacity()) {
            this.expandCapacity(n);
        }
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasData() {
        this.setOutputMode();
        return this.buffer.hasRemaining();
    }

    @Override
    public int length() {
        this.setOutputMode();
        return this.buffer.remaining();
    }

    @Override
    public int available() {
        this.setInputMode();
        return this.buffer.remaining();
    }

    protected void clear() {
        this.buffer.clear();
        this.mode = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[mode=");
        if (this.getMode() == 0) {
            stringBuilder.append("in");
        } else {
            stringBuilder.append("out");
        }
        stringBuilder.append(" pos=");
        stringBuilder.append(this.buffer.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(this.buffer.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(this.buffer.capacity());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

