/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.nio.ContentDecoder;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentInputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;

public class SimpleInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private boolean endOfStream = false;

    public SimpleInputBuffer(int n, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
    }

    public SimpleInputBuffer(int n) {
        this(n, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public void reset() {
        this.endOfStream = false;
        super.clear();
    }

    @Override
    public int consumeContent(ContentDecoder contentDecoder) throws IOException {
        int n;
        this.setInputMode();
        int n2 = 0;
        while ((n = contentDecoder.read(this.buffer)) != -1) {
            if (n == 0) {
                if (this.buffer.hasRemaining()) break;
                this.expand();
                continue;
            }
            n2 += n;
        }
        if (n == -1 || contentDecoder.isCompleted()) {
            this.endOfStream = true;
        }
        return n2;
    }

    public boolean isEndOfStream() {
        return !this.hasData() && this.endOfStream;
    }

    @Override
    public int read() throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        this.setOutputMode();
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        this.setOutputMode();
        int n3 = n2;
        if (n3 > this.buffer.remaining()) {
            n3 = this.buffer.remaining();
        }
        this.buffer.get(byArray, n, n3);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        if (this.isEndOfStream()) {
            return -1;
        }
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    public void shutdown() {
        this.endOfStream = true;
    }
}

