/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.nio.ContentEncoder;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;

public class SimpleOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private boolean endOfStream = false;

    public SimpleOutputBuffer(int n, ByteBufferAllocator byteBufferAllocator) {
        super(n, byteBufferAllocator);
    }

    public SimpleOutputBuffer(int n) {
        this(n, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public int produceContent(ContentEncoder contentEncoder) throws IOException {
        this.setOutputMode();
        int n = contentEncoder.write(this.buffer);
        if (!this.hasData() && this.endOfStream) {
            contentEncoder.complete();
        }
        return n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.buffer.position() + n2);
        this.buffer.put(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.capacity() + 1);
        this.buffer.put((byte)n);
    }

    @Override
    public void reset() {
        super.clear();
        this.endOfStream = false;
    }

    @Override
    public void flush() {
    }

    @Override
    public void writeCompleted() {
        this.endOfStream = true;
    }

    public void shutdown() {
        this.endOfStream = true;
    }
}

